/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.rpc.aio.client;

import cn.tdchain.cipher.rsa.AesUtil;
import cn.tdchain.jbcc.TimerUtil;
import cn.tdchain.jbcc.rpc.aio.engage.FixedLengthProtocol;
import cn.tdchain.jbcc.rpc.aio.engage.HandShakeStatus;
import cn.tdchain.jbcc.rpc.aio.engage.StringClientProcessor;
import cn.tdchain.jbcc.rpc.aio.handler.*;
import org.smartboot.socket.transport.AioQuickClient;
import org.smartboot.socket.transport.AioSession;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;

public class AioRpcClient {

    private String serverPublicKey = null;
    private String token = null;
    private AioQuickClient<String> aioQuickClient;
    private AioSession<String> aioSession;
    private StringClientProcessor stringClientProcessor;
    private String connectionId;

    public AioRpcClient(String address, int port, String token, String connectionId, String clientPublicKey) throws InterruptedException, ExecutionException, IOException {
        stringClientProcessor = new StringClientProcessor();
        aioQuickClient = new AioQuickClient(address, port, new FixedLengthProtocol(), stringClientProcessor);
        AioSession<String> start = aioQuickClient.start();
        this.aioSession = start;
        this.connectionId = connectionId;
        AioAuthClientHandler aioAuthClientHandler = new AioAuthClientHandler(token, connectionId, clientPublicKey);
        stringClientProcessor.getPipline().addLast(aioAuthClientHandler);
        this.token = token;
        this.connect();
    }

    private AioSession<String> connect() {
        try {
            String uuid = UUID.randomUUID().toString();
            String encode = AesUtil.encrypt(uuid, this.token);
            AioAuthClientHandler handler = (AioAuthClientHandler) stringClientProcessor.pipline.getHandler(AioAuthClientHandler.class);
            handler.getHandshakerMap().put(HandShakeStatus.AUTH, uuid);
            this.aioSession.write(encode);
            String serverPublickey = TimerUtil.exec(100, 50, () -> {
                String serverPublicKey = handler.getServerPublicKey();
                return serverPublicKey;
            });
            if (serverPublickey == null) {
                this.aioSession.close();
                return null;
            }
            this.serverPublicKey = serverPublickey;
            stringClientProcessor.pipline.remove(AioAuthClientHandler.class);
            return this.aioSession;
        } catch (IOException e) {
            close();
            e.printStackTrace();
        }
        return null;
    }


    public void close() {
        if (this.aioQuickClient != null) {
            this.aioQuickClient.shutdown();
        }
    }

    public void send(String msg) {
        try {
            this.aioSession.write(msg);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isActive() {
        return !aioSession.isInvalid();
    }

    public void setServerPublicKey(String serverPublicKey) {
        this.serverPublicKey = serverPublicKey;
    }

    public AioSession<String> getAioSession() {
        return aioSession;
    }

    public void setAioSession(AioSession<String> aioSession) {
        this.aioSession = aioSession;
    }

    public String getServerPublicKey() {
        return serverPublicKey;
    }

    public StringClientProcessor getStringClientProcessor() {
        return stringClientProcessor;
    }

    public void setStringClientProcessor(StringClientProcessor stringClientProcessor) {
        this.stringClientProcessor = stringClientProcessor;
    }

    public String getConnectionId() {
        return connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }
}
