/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.rpc.aio.client;

import cn.tdchain.jbcc.TimerUtil;
import cn.tdchain.jbcc.rpc.aio.engage.AioPoolableRpcClientFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class AioRpcClientPool extends GenericObjectPool<AioRpcClient> {
    private AioRpcClient aioRpcClient;

    public AioRpcClientPool(AioPoolableRpcClientFactory factory, GenericObjectPoolConfig config) {
        super(factory, config);
    }

    public boolean isAlived() {
        if (aioRpcClient == null || !aioRpcClient.isActive()) {
            AioRpcClient np = TimerUtil.exec(0, 3, () -> {
                AioRpcClient aioRpcClient = this.borrowObject();
                if (aioRpcClient == null) {
                    return null;
                }
                return aioRpcClient;
            });
            if (np == null) {
                return false;
            }
            this.aioRpcClient = np;
            return np.isActive();
        }
        return aioRpcClient.isActive();
    }
}
