/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.rpc.aio.client;

import cn.tdchain.jbcc.rpc.aio.handler.AioSynReponseClientHandler;
import org.smartboot.socket.transport.AioSession;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class AioRpcSynResponseClient extends AioAbstractClient {

    public AioRpcSynResponseClient(AioRpcClient aioRpcClient) {
        super(aioRpcClient);
        if (aioRpcClient != null && aioRpcClient.isActive()) {
            this.aioRpcClient.getStringClientProcessor().getPipline().addLast(new AioSynReponseClientHandler());
        }
    }

    /**
     * Send message and get response.
     * @param message
     * @return String
     * @throws InterruptedException
     */
    public synchronized String sendAndReturn(String message) throws InterruptedException {
        return sendAndReturn(message, 1000);
    }

    /**
     * Send message and get response.
     * 
     * @param message
     * @param timeMillis
     * @return String
     * @throws InterruptedException
     */
    public synchronized String sendAndReturn(String message, long timeMillis) throws InterruptedException {
        if (message == null) {
            return null;
        }
        AioSession session = this.aioRpcClient.getAioSession();
        AioSynReponseClientHandler aioSynReponseClientHandler = (AioSynReponseClientHandler) aioRpcClient.getStringClientProcessor().getPipline().getHandler(AioSynReponseClientHandler.class);
        CountDownLatch count = aioSynReponseClientHandler.getCountDownLatch();
        if (count != null) {
            count.await(timeMillis, TimeUnit.MILLISECONDS);
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        aioSynReponseClientHandler.setCountDownLatch(countDownLatch);
        try {
            session.write(message);
            countDownLatch.await(timeMillis, TimeUnit.MILLISECONDS);
            return aioSynReponseClientHandler.getMsg();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            countDownLatch.countDown();
        }
        return null;
    }

}


