/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.rpc.aio.engage;

import cn.tdchain.jbcc.net.aio.AioNet;
import cn.tdchain.jbcc.rpc.aio.client.AioRpcClient;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class AioPoolableRpcClientFactory extends BasePooledObjectFactory<AioRpcClient> {

    private String clientPublicKey = null;
    private String address = null;
    private String token = null;
    private int port;
    private long timeout = -1L;
    private String connectionId;

    private AioNet.AioTask task;

    public AioPoolableRpcClientFactory(String address, int port, String token, String connectionId, String clientPublicKey, AioNet.AioTask task) {
        super();
        this.address = address;
        this.port = port;
        this.token = token;
        this.clientPublicKey = clientPublicKey;
        this.task = task;
        this.connectionId = connectionId;
    }

    @Override
    public AioRpcClient create() {
        AioRpcClient client = null;
        try {
            client = new AioRpcClient(address, port, token, connectionId, clientPublicKey);
        } catch (Exception e) {
            e.printStackTrace();
        }
        //client.getChannel().pipeline().get(ReceiveSysMessageChannelHandler.class).setTask(task);
        return client;
    }

    @Override
    public PooledObject<AioRpcClient> wrap(AioRpcClient client) {
        return new DefaultPooledObject<>(client);
    }

    @Override
    public void passivateObject(PooledObject<AioRpcClient> object) {
        if (object != null) {
            AioRpcClient client = object.getObject();
            if (!client.isActive()) {
                try {
                    destroyObject(wrap(client));
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void destroyObject(PooledObject<AioRpcClient> object) {
        if (object != null) {
            AioRpcClient client = object.getObject();
            client.close();
        }
    }

}
