/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.rpc.aio.engage;

import org.smartboot.socket.transport.AioSession;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class AioSessionCache {
    private static final ConcurrentHashMap<AioSession, Map<HandShakeStatus, String>> cmap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<AioSession, HandlerPipline> piplineMap = new ConcurrentHashMap<>();
    private static final ConcurrentHashMap<AioSession, String> clientKeyMap = new ConcurrentHashMap<>();

    static {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        scheduledExecutorService.scheduleAtFixedRate(() -> {
            List<AioSession> aioSessions = new ArrayList<>();
            aioSessions.addAll(cmap.keySet());
            aioSessions.addAll(piplineMap.keySet());
            aioSessions.addAll(clientKeyMap.keySet());
            aioSessions.forEach(session -> {
                if (session.isInvalid()) {
                    cmap.remove(session);
                    piplineMap.remove(session);
                    clientKeyMap.remove(session);
                }
            });
        }, 0, 3000, TimeUnit.MILLISECONDS);
    }

    public static ConcurrentHashMap<AioSession, Map<HandShakeStatus, String>> getCmap() {
        return cmap;
    }

    public static ConcurrentHashMap<AioSession, HandlerPipline> getPiplineMap() {
        return piplineMap;
    }

    public static ConcurrentHashMap<AioSession, String> getClientKeyMap() {
        return clientKeyMap;
    }
}
