/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.rpc.aio.engage;

import cn.tdchain.jbcc.rpc.aio.server.AioRpcServer;
import org.smartboot.socket.transport.AioSession;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class AioThreadResponseHandler {
    private static AioThreadResponseHandler aioThreadResponseHandler = null;
    private  Map<AioSession, String> channelMap = new ConcurrentHashMap<>();
    private static ScheduledExecutorService scheduledExecutorService = null;
    
    private AioThreadResponseHandler() {
    	scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        scheduledExecutorService.scheduleAtFixedRate(() ->
                        channelMap.forEach((k, v) -> {
                            if (!k.isInvalid()) {
                                String sendPublicKey = AioRpcServer.getStringServerProcessor().getClientKeyMap().get(k);
                                String result = AioRpcServer.getStringServerProcessor().getAioRpcServer().getHandler().getResultMapByConnectionId(v, sendPublicKey);
                                if (result != null) {
                                    try {
                                        k.write(result);
                                    } catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                            } else {
                                channelMap.remove(k);
                            }
                        })
                , 0, 30, TimeUnit.MILLISECONDS);
    }

    public void handle(AioSession session, String connId) {
        if (!channelMap.containsKey(session)) {
            channelMap.put(session, connId);
        }
    }

    public static AioThreadResponseHandler singleInstance() {
    	if(aioThreadResponseHandler == null) {
    		aioThreadResponseHandler = new AioThreadResponseHandler();
    	}
        return aioThreadResponseHandler;
    }
    
    public void close() {
    	if(scheduledExecutorService != null) {
    		scheduledExecutorService.shutdownNow();
    	}
    }

}
