/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.rpc.aio.engage;

import cn.tdchain.jbcc.rpc.aio.handler.InHandler;
import org.smartboot.socket.transport.AioSession;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class HandlerPipline {
    List<HandlerContext> handlerContexts = new ArrayList<>();
    private final HandlerContext head = new HandlerContext();
    private final HandlerContext tail = new HandlerContext();

    public HandlerPipline() {
        head.pipline = this;
        tail.pipline = this;
    }

    public synchronized void addLast(InHandler inHandler) {
        if (inHandler == null) {
            return;
        }
        boolean b = handlerContexts.stream().anyMatch(h -> h.getHandler().getClass() == inHandler.getClass());
        if (b) {
            throw new RuntimeException("已存在:" + inHandler.getClass().getName());
        }
        HandlerContext context = new HandlerContext();
        context.pipline = this;
        context.handler = inHandler;
        HandlerContext pre = tail.getPre();
        if (pre == null) {
            // 首位设置
            head.next = context;
            tail.pre = context;
            // 设置链表前后对象
            context.pre = head;
            context.next = tail;
            handlerContexts.add(context);
            return;
        }
        pre.next = context;
        context.next = tail;
        tail.pre = context;
        handlerContexts.add(context);
    }

    public void process(AioSession<String> session, String msg) {
        if (head.aioSession == null) {
            head.setAioSession(session);
        }
        head.fireChannelRead(head, msg);
    }

    public InHandler getHandler(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Optional<HandlerContext> first = handlerContexts.stream().filter(h -> h.getHandler().getClass() == clazz).findFirst();
        if (first.isPresent()) {
            return first.get().getHandler();
        }
        return null;
    }

    public synchronized void remove(InHandler inHandler) {
        if (inHandler == null) {
            return;
        }
        this.remove(inHandler.getClass());
    }

    public synchronized void remove(Class clazz) {
        if (clazz == null) {
            return;
        }
        for (HandlerContext context : handlerContexts) {
            if (context.getHandler().getClass() != clazz) {
                continue;
            }
            if (context == tail || context == head) {
                continue;
            }
            HandlerContext pre = context.getPre();
            HandlerContext next = context.next;

            pre.next = next;
            next.pre = pre;
            handlerContexts.remove(context);
            break;
        }
    }

    public static class HandlerContext {
        private HandlerPipline pipline;
        private HandlerContext next;
        private HandlerContext pre;
        private AioSession aioSession;
        private InHandler handler;

        private HandlerContext() {
        }

        public void fireChannelRead(HandlerContext context, Object msg) {
            HandlerContext next = context.next;
            next.setAioSession(context.getAioSession());
            next.channelRead(next, msg);
        }

        private void channelRead(HandlerContext context, Object msg) {
            InHandler handler = context.getHandler();
            if (handler != null) {
                try {
                    handler.channelRead(context, msg);
                } catch (Exception e) {
                    handler.exceptionCaught(context, e);
                }
            }
        }

        public void fireExceptionCaught(HandlerContext context, Exception e) {
            HandlerContext next = context.next;
            next.setAioSession(context.getAioSession());
            next.exceptionCaught(next, e);
        }

        public void exceptionCaught(HandlerContext context, Exception e) {
            InHandler handler = context.getHandler();
            if (handler != null) {
                handler.exceptionCaught(context, e);
            }
        }

        public HandlerPipline getPipline() {
            return pipline;
        }

        public void setPipline(HandlerPipline pipline) {
            this.pipline = pipline;
        }

        public HandlerContext getPre() {
            return pre;
        }

        public void setPre(HandlerContext pre) {
            this.pre = pre;
        }

        public InHandler getHandler() {
            return handler;
        }

        public void setHandler(InHandler handler) {
            this.handler = handler;
        }

        public AioSession getAioSession() {
            return aioSession;
        }

        public void setAioSession(AioSession aioSession) {
            this.aioSession = aioSession;
        }

        public void close() {
            if (this.aioSession != null) {
                aioSession.close();
            }
        }

        public void write(Object msg) throws IOException {
            if (this.aioSession != null) {
                this.aioSession.write(msg);
            }
        }
    }
}
