/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.rpc.aio.engage;

import cn.tdchain.jbcc.rpc.aio.handler.InHandler;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.transport.AioSession;

import java.util.concurrent.ConcurrentHashMap;


public abstract class ServerPiplineProcessor<T> implements MessageProcessor<T> {

    private final ConcurrentHashMap<AioSession, HandlerPipline> piplineMap = AioSessionCache.getPiplineMap();
    private final ConcurrentHashMap<AioSession, String> clientKeyMap = AioSessionCache.getClientKeyMap();
    private final ConcurrentHashMap<Class<? extends InHandler>, InHandler> handlerPool = new ConcurrentHashMap<>();

    public synchronized void addLastHandler(AioSession session, InHandler handler) {
        HandlerPipline handlerPipline = piplineMap.get(session);
        if (handlerPipline != null) {
            handlerPipline.addLast(handler);
        } else {
            HandlerPipline pip = new HandlerPipline();
            pip.addLast(handler);
            piplineMap.put(session, pip);
        }
    }

    public synchronized void addLastHandler(AioSession session, Class<? extends InHandler> clazz) {
        InHandler handler = null;
        try {
            if (handlerPool.containsKey(clazz)) {
                handler = handlerPool.get(clazz);
            } else {
                handler = clazz.newInstance();
            }
            handlerPool.put(clazz, handler);
        } catch (Exception e) {
            throw new RuntimeException("实例化inHandler失败:" + e.getMessage());
        }
        addLastHandler(session, handler);
    }

    public synchronized void removeHandler(AioSession session, Class clazz) {
        HandlerPipline handlerPipline = piplineMap.get(session);
        if (handlerPipline != null) {
            handlerPipline.remove(clazz);
        }
    }

    public synchronized void addKey(AioSession session, String key) {
        clientKeyMap.put(session, key);
    }

    public synchronized void removeKey(AioSession session) {
        clientKeyMap.remove(session);
    }


    public void handle(AioSession session, String msg) throws Exception {
        HandlerPipline handlerPipline = piplineMap.get(session);
        if (handlerPipline != null) {
            handlerPipline.process(session, msg);
        }
    }

    public synchronized void remove(AioSession session) {
        piplineMap.remove(session);
    }

    public ConcurrentHashMap<AioSession, String> getClientKeyMap() {
        return clientKeyMap;
    }
}