/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.rpc.aio.engage;

import cn.tdchain.jbcc.SoutUtil;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.transport.AioSession;


public class StringClientProcessor extends ClientPiplineProcessor<String> {

    public void process(AioSession<String> session, String msg) {
        if (msg != null) {
            pipline.process(session, msg);
        }
    }

    public void stateEvent(AioSession<String> session, StateMachineEnum stateMachineEnum, Throwable throwable) {
        String name = "default";
        if (stateMachineEnum != null)
            name = stateMachineEnum.name().toUpperCase();

        if (SoutUtil.isOpenSout()) {
            System.out.println("StateMachineEnum." + name);
        }

    }

}