/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.rpc.aio.handler;

import cn.tdchain.cipher.rsa.AesUtil;
import cn.tdchain.jbcc.rpc.aio.engage.HandShakeStatus;
import cn.tdchain.jbcc.rpc.aio.engage.HandlerPipline;

import java.util.HashMap;
import java.util.Map;

public class AioAuthClientHandler implements InHandler<String> {
    private Map<HandShakeStatus, String> handshakerMap = new HashMap<>();
    private String token;
    private String publicKey;
    private String serverPublicKey;
    private String connectionId;

    public AioAuthClientHandler(String token, String connectionId, String publicKey) {
        this.token = token;
        this.connectionId = connectionId;
        this.publicKey = publicKey;
    }

    @Override
    public void channelRead(HandlerPipline.HandlerContext context, Object msg) throws Exception {
        String authSequence = (String) msg;
        if (!handshakerMap.containsKey(HandShakeStatus.HAND_2)) {
            String data = handshakerMap.get(HandShakeStatus.AUTH);
            String decode = authSequence.split(";")[0];//明文
            String encode = authSequence.split(";")[1]; //对方密文
            if (data.equals(decode)) {
                data = AesUtil.decrypt(encode, token);
                if (data != null) {
                    handshakerMap.put(HandShakeStatus.HAND_2, HandShakeStatus.HAND_2.name());
                    context.write(data);
                }
            }
            return;
        }
        if (!handshakerMap.containsKey(HandShakeStatus.HAND_3)) {
            // 第二次握手逻辑,接收服务端公钥
            handshakerMap.put(HandShakeStatus.SERVER_PUBLIC_KEY, authSequence);
            handshakerMap.put(HandShakeStatus.HAND_3, HandShakeStatus.HAND_3.name());
            // 发送自己的公钥和connection给服务端
            String keyAndConnectionId = publicKey + ";" + connectionId;
            context.write(keyAndConnectionId);
            this.serverPublicKey = authSequence;
        }
    }

    @Override
    public void exceptionCaught(HandlerPipline.HandlerContext context, Throwable cause) {

    }

    public Map<HandShakeStatus, String> getHandshakerMap() {
        return handshakerMap;
    }

    public void setHandshakerMap(Map<HandShakeStatus, String> handshakerMap) {
        this.handshakerMap = handshakerMap;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getPublicKey() {
        return publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getServerPublicKey() {
        return serverPublicKey;
    }

    public void setServerPublicKey(String serverPublicKey) {
        this.serverPublicKey = serverPublicKey;
    }
}
