/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.rpc.aio.handler;

import cn.tdchain.cipher.rsa.AesUtil;
import cn.tdchain.cipher.rsa.RsaUtil;
import cn.tdchain.jbcc.net.ConnectionCount;
import cn.tdchain.jbcc.rpc.aio.engage.AioSessionCache;
import cn.tdchain.jbcc.rpc.aio.engage.HandShakeStatus;
import cn.tdchain.jbcc.rpc.aio.engage.HandlerPipline;
import cn.tdchain.jbcc.rpc.aio.engage.StringServerProcessor;
import cn.tdchain.jbcc.rpc.aio.server.AioRpcServer;
import cn.tdchain.tdmsp.Msp;
import org.smartboot.socket.transport.AioSession;

import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

/**
 * TCP message handler.
 *
 * @author murong 2018-08-03
 * @version 1.0
 */
public class AioAuthServerHandler implements InHandler<String> {

    private ConcurrentHashMap<AioSession, Map<HandShakeStatus, String>> cmap = AioSessionCache.getCmap();

    public void channelRead(HandlerPipline.HandlerContext context, Object msg) throws Exception {
        String str = (String) msg;
        if (str == null || str.length() == 0) {
            context.close();
        }
        if (!cmap.containsKey(context.getAioSession())) {
            Map<HandShakeStatus, String> clientmap = new HashMap<>();
            cmap.put(context.getAioSession(), clientmap);
        }
        Map<HandShakeStatus, String> handshakeMap = cmap.get(context.getAioSession());
        if (!handshakeMap.containsKey(HandShakeStatus.HAND_1)) {
            String c_data = AesUtil.decrypt(str, AioRpcServer.getStringServerProcessor().getAioRpcServer().getToken());
            String s_data = UUID.randomUUID().toString();
            String s_r_data = c_data + ";" + AesUtil.encrypt(s_data, AioRpcServer.getStringServerProcessor().getAioRpcServer().getToken());
            handshakeMap.put(HandShakeStatus.AUTH, s_data);
            handshakeMap.put(HandShakeStatus.HAND_1, HandShakeStatus.HAND_1.name());
            context.write(s_r_data);
            return;
        }
        if (!handshakeMap.containsKey(HandShakeStatus.HAND_2)) {
            String s_data = handshakeMap.get(HandShakeStatus.AUTH);
            if (s_data.equals(str)) {
                handshakeMap.put(HandShakeStatus.HAND_2, HandShakeStatus.HAND_2.name());
                context.write(AioRpcServer.getStringServerProcessor().getAioRpcServer().getKey().getPublicKey());
            }
            return;
        }
        if (!handshakeMap.containsKey(HandShakeStatus.HAND_3)) {
            String[] splits = str.split(";");
            String clientCertBase64Str = splits[0];
            String connectId = splits[1];
            X509Certificate clientCert = Msp.base64StringToCert(clientCertBase64Str);
            boolean leg = Msp.validateCert(Msp.base64StringToCert(AioRpcServer.getStringServerProcessor().getAioRpcServer().getKey().getRootCertBase64String()), clientCert);//验证客户端证书是否合法?
            if (leg) {
                //合法证书,提取公钥。
                String clientPubliKey = RsaUtil.getPublicKey(clientCert.getPublicKey());
                //允许建立长连接
                handshakeMap.put(HandShakeStatus.CLIENT_PUBLIC_KEY, clientPubliKey);
                handshakeMap.put(HandShakeStatus.HAND_3, HandShakeStatus.HAND_3.name());
                String orgName = Msp.getOrganizationName(clientCert);
                if (ConnectionCount.newInstance().checkSingle(connectId, clientPubliKey)) {
                    ConnectionCount.newInstance().handleConnection(connectId, clientPubliKey, orgName, context.getAioSession());
                } else {
                    throw new RuntimeException("aio shake  failed! Illegal certificate. params");
                }
            } else {
                throw new RuntimeException("aio shake  failed! Illegal certificate.");
            }

        }
        if (handshakeMap.containsKey(HandShakeStatus.CLIENT_PUBLIC_KEY)) {
            StringServerProcessor stringServerProcessor = AioRpcServer.getStringServerProcessor();
            stringServerProcessor.getClientKeyMap().put(context.getAioSession(), handshakeMap.get(HandShakeStatus.CLIENT_PUBLIC_KEY));
            stringServerProcessor.removeHandler(context.getAioSession(), AioAuthServerHandler.class);
            stringServerProcessor.addLastHandler(context.getAioSession(), AioServerHandler.class);
            // 删除
            cmap.remove(context.getAioSession());
        }
    }

    @Override
    public void exceptionCaught(HandlerPipline.HandlerContext context, Throwable cause) {
        cause.printStackTrace();
        context.close();
    }

    public ConcurrentHashMap<AioSession, Map<HandShakeStatus, String>> getCmap() {
        return cmap;
    }
}
