/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.rpc.aio.handler;

import cn.tdchain.cipher.DataCipher;
import cn.tdchain.jbcc.SoutUtil;
import cn.tdchain.jbcc.net.aio.AioNet;
import cn.tdchain.jbcc.net.aio.AioResphone;
import cn.tdchain.jbcc.rpc.RPCResult;
import cn.tdchain.jbcc.rpc.aio.engage.HandlerPipline;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;

import java.util.Map;

/**
 * Synchronize AioAbstractClient Handler.
 *
 * @author murong.H 2018-08-17
 * @version 1.0
 */
public class AioResponseClientHandler implements InHandler<String> {
    private int errorNum = 0;
    private AioResphone aioResphone;
    private AioNet.AioTask task;

    @Override
    public void channelRead(HandlerPipline.HandlerContext context, Object msg) throws Exception {
        String message = (String) msg;
        RPCResult r = JSONObject.parseObject(message, RPCResult.class);
        if (r != null && r.getType() == RPCResult.ResultType.batch_resphone) {
            //解密获取明文
            String cipher_data = r.getEntity();//密文DataCipher
            DataCipher data = JSONObject.parseObject(cipher_data, DataCipher.class);
            String data_str = data.getData(aioResphone.getKey().getPrivateKey(), aioResphone.getCipher());
            if (data_str == null) {
                return;
            }
            Map<String, RPCResult> connectionMap = JSON.parseObject(data_str, new TypeReference<Map<String, RPCResult>>() {
            });
            if (connectionMap != null && connectionMap.size() > 0) {
                aioResphone.getPool().add(connectionMap);//把结果添加到池中
            }
        }
        errorNum = 0;
    }

    @Override
    public void exceptionCaught(HandlerPipline.HandlerContext context, Throwable cause) {
        this.errorNum++;
        if (SoutUtil.isOpenSout())
            System.out.println("打印:get an error times:" + errorNum);
        cause.printStackTrace();
        if (this.errorNum >= 5) {
            errorNum = 0;
            if (task != null) {
                task.setStatus(false);
            }
        }
    }

    public int getErrorNum() {
        return errorNum;
    }

    public void setErrorNum(int errorNum) {
        this.errorNum = errorNum;
    }


    public AioResphone getAioResphone() {
        return aioResphone;
    }

    public void setAioResphone(AioResphone aioResphone) {
        this.aioResphone = aioResphone;
    }

    public AioNet.AioTask getTask() {
        return task;
    }

    public void setTask(AioNet.AioTask task) {
        this.task = task;
    }
}
