/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.rpc.aio.handler;

import cn.tdchain.jbcc.rpc.RPCMessage;
import cn.tdchain.jbcc.rpc.aio.engage.AioThreadResponseHandler;
import cn.tdchain.jbcc.rpc.aio.engage.HandlerPipline;
import cn.tdchain.jbcc.rpc.aio.server.AioRpcServer;
import com.alibaba.fastjson.JSONObject;

/**
 * TCP message handler.
 *
 * @author murong 2018-08-03
 * @version 1.0
 */
public class AioServerHandler implements InHandler {

    @Override
    public void channelRead(HandlerPipline.HandlerContext context, Object rmsg) throws Exception {
        String str = (String) rmsg;
        RPCMessage msg = JSONObject.parseObject(str, RPCMessage.class);
        // 获取通道设置的publickey
        String sendPublicKey = AioRpcServer.getStringServerProcessor().getClientKeyMap().get(context.getAioSession());
        if (sendPublicKey == null) {
            return;
        }
        String connectionId = msg.getSender();
        if (RPCMessage.TargetType.BATCH_RESPHONE == msg.getTargetType()) {
            AioThreadResponseHandler.singleInstance().handle(context.getAioSession(), connectionId);
        } else {
            // 一般是request的请求
            String result = AioRpcServer.getStringServerProcessor().getAioRpcServer().getHandler().handler(msg, connectionId);
            if (result != null) {
                context.write(result);
            }
        }
    }

    @Override
    public void exceptionCaught(HandlerPipline.HandlerContext context, Throwable cause) {

    }

}
