/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.rpc.aio.handler;

import cn.tdchain.jbcc.rpc.aio.engage.HandlerPipline;

import java.util.concurrent.CountDownLatch;

/**
 * Synchronize AioAbstractClient Handler.
 *
 * @author murong.H 2018-08-17
 * @version 1.0
 */
public class AioSynReponseClientHandler implements InHandler<String> {
    private String msg;
    private CountDownLatch countDownLatch;


    @Override
    public void channelRead(HandlerPipline.HandlerContext context, Object obj) throws Exception {
        try {
            String message = (String) obj;
            msg = message;
        } finally {
            if (countDownLatch != null) {
                countDownLatch.countDown();
            }
        }
    }

    @Override
    public void exceptionCaught(HandlerPipline.HandlerContext context, Throwable cause) {

    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public CountDownLatch getCountDownLatch() {
        return countDownLatch;
    }

    public void setCountDownLatch(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }
}
