/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.rpc.aio.server;

import cn.tdchain.cipher.Key;
import cn.tdchain.jbcc.rpc.MessageHandler;
import cn.tdchain.jbcc.rpc.RpcServer;
import cn.tdchain.jbcc.rpc.aio.engage.FixedLengthProtocol;
import cn.tdchain.jbcc.rpc.aio.engage.StringServerProcessor;
import org.smartboot.socket.transport.AioQuickServer;

import java.io.IOException;


/**
 * rpc server.
 *
 * @author murong 2017-12-13
 * @version 2.0
 */
public class AioRpcServer implements RpcServer {

    private AioQuickServer<String> aioQuickServer;

    private String token;

    private int port;

    private MessageHandler handler;

    private Key key;

    private static final StringServerProcessor stringServerProcessor = new StringServerProcessor();

    /**
     * Constructor.
     * @param port
     * @param handler
     * @param token
     * @param key
     */
    public AioRpcServer(int port, MessageHandler handler, String token, Key key) {
        stringServerProcessor.setAioRpcServer(AioRpcServer.this);
        aioQuickServer = new AioQuickServer<>(port, new FixedLengthProtocol(), stringServerProcessor);
        this.port = port;
        this.handler = handler;
        this.token = token;
        this.key = key;
    }

    /**
     * Start server.
     */
    public void startServer() {
        try {
            this.aioQuickServer.start();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public AioQuickServer<String> getAioQuickServer() {
        return aioQuickServer;
    }

    public void setAioQuickServer(AioQuickServer<String> aioQuickServer) {
        this.aioQuickServer = aioQuickServer;
    }

    public MessageHandler getHandler() {
        return handler;
    }

    public void setHandler(MessageHandler handler) {
        this.handler = handler;
    }

    public static StringServerProcessor getStringServerProcessor() {
        return stringServerProcessor;
    }

    public Key getKey() {
        return key;
    }

    public void setKey(Key key) {
        this.key = key;
    }
}

