/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.rpc.nio.handler;

import cn.tdchain.jbcc.rpc.nio.server.NioRpcServer;
import io.netty.channel.Channel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NioThreadResponseHandler {
    private static NioThreadResponseHandler nioThreadResponseHandler;
    private NioRpcServer nioRpcServer;

    private NioThreadResponseHandler(NioRpcServer nioRpcServer) {
        this.nioRpcServer = nioRpcServer;
        this.thread.start();
    }

    private Map<Channel, String> channelMap = new ConcurrentHashMap<>();
    private Thread thread = new Thread(() -> {
        while (true) {
            try {
                channelMap.forEach((k, v) -> {
                    if (k.isActive()) {
                        Attribute<String> attr = k.attr(AttributeKey.valueOf(NioHandshakerType.CLIENT_PUBLIC_KEY.name()));
                        String sendPublicKey = attr.get();
                        String result = nioRpcServer.getHandler().getResultMapByConnectionId(v, sendPublicKey);
                        if (result != null) {
                            k.writeAndFlush(result);
                        }
                    } else {
                        channelMap.remove(k);
                    }
                });
                Thread.sleep(10l);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    });

    public void handle(Channel channel, String connId) {
        if (!channelMap.containsKey(channel)) {
            channelMap.put(channel, connId);
        }
    }

    public synchronized static NioThreadResponseHandler singleInstance(NioRpcServer nioRpcServer) {
        if (nioThreadResponseHandler == null) {
            nioThreadResponseHandler = new NioThreadResponseHandler(nioRpcServer);
        }
        return nioThreadResponseHandler;
    }

}
