/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain;

import cn.tdchain.Trans;
import cn.tdchain.cipher.rsa.Sha256Util;
import cn.tdchain.jbcc.BlockException;
import cn.tdchain.jbcc.MerkleUtil;
import cn.tdchain.jbcc.TransUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;

public class Block<T extends Trans> {
    protected Long height;
    protected String hash;
    protected String preHash;
    protected String merkleRoot;
    protected String timestamp;
    protected String sign;
    protected int count;
    protected List<T> trans;

    public Long getHeight() {
        return this.height;
    }

    public void setHeight(Long height) {
        this.height = height;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getPreHash() {
        return this.preHash;
    }

    public void setPreHash(String preHash) {
        this.preHash = preHash;
    }

    public String getMerkleRoot() {
        return this.merkleRoot;
    }

    public void setMerkleRoot(String merkleRoot) {
        this.merkleRoot = merkleRoot;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public List<T> getTrans() {
        return this.trans;
    }

    public void setTrans(List<T> trans) {
        this.trans = trans;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String toJsonString() {
        return JSON.toJSONString((Object)this);
    }

    public void check() {
        List<T> t_list = this.getTrans();
        if (t_list == null || t_list.size() == 0) {
            throw new BlockException("block list is null.");
        }
        ArrayList<String> blockHashList = new ArrayList<String>(this.getCount());
        for (Trans trans : t_list) {
            String hash = TransUtil.getHash(trans);
            blockHashList.add(hash);
        }
        String merkleRoot = MerkleUtil.getMerkleRoot(blockHashList);
        if (this.getMerkleRoot() == null || !merkleRoot.equals(this.getMerkleRoot())) {
            throw new BlockException("block merkle root error.");
        }
        String hash = Sha256Util.hash(this.getMerkleRoot() + this.getPreHash() + this.getTimestamp());
        if (this.getHash() == null || !this.getHash().equals(hash)) {
            throw new BlockException("block hash error.");
        }
    }
}

