/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cipher;

import cn.tdchain.cipher.Key;
import cn.tdchain.cipher.rsa.AesUtil;
import cn.tdchain.cipher.rsa.RSAKeyStoreUtil;
import cn.tdchain.cipher.rsa.RsaUtil;
import cn.tdchain.cipher.rsa.Sha256Util;
import cn.tdchain.cipher.sm.Sm2Util;
import cn.tdchain.cipher.sm.Sm3Util;
import cn.tdchain.cipher.sm.Sm4Util;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;

public class Cipher {
    private Type type = Type.RSA;

    public void generateKeyStoreFile(String path, String password, String alias) {
        if (this.type == Type.RSA) {
            RSAKeyStoreUtil.genKey(path, password, alias);
        }
    }

    public Key generateKey() {
        Key key = new Key();
        if (this.type == Type.RSA) {
            KeyPair keyPair = RsaUtil.generKey();
            key.setPublicKey(RsaUtil.getPublicKey(keyPair.getPublic()));
            key.setPrivateKey(RsaUtil.getPrivateKey(keyPair.getPrivate()));
        } else {
            try {
                KeyPair keyPair = Sm2Util.generateSm2KeyPair();
                String privateKey = Base64.getEncoder().encodeToString(keyPair.getPrivate().getEncoded());
                String publicKey = Base64.getEncoder().encodeToString(keyPair.getPublic().getEncoded());
                key.setPrivateKey(privateKey);
                key.setPublicKey(publicKey);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return key;
    }

    public PublicKey getPublicKey(String publicKey) {
        try {
            return RsaUtil.getPublicKey(publicKey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        return null;
    }

    public String hash(String text) {
        if (this.type == Type.RSA) {
            return Sha256Util.hash(text);
        }
        return Sm3Util.hash(text);
    }

    public String encrypt(String data, String passwd) {
        if (this.type == Type.RSA) {
            return AesUtil.encrypt(data, passwd);
        }
        return Sm4Util.encryptECB(data, passwd);
    }

    public String decrypt(String data, String passwd) {
        if (this.type == Type.RSA) {
            return AesUtil.decrypt(data, passwd);
        }
        return Sm4Util.decryptECB(data, passwd);
    }

    public String encryptByPublicKey(String data, String publicKey) {
        if (this.type == Type.RSA) {
            return RsaUtil.encrypt(data, publicKey);
        }
        return Sm2Util.encrypt(publicKey, data);
    }

    public String encryptByPublicKey(String data, PublicKey publicKey) {
        if (this.type == Type.RSA) {
            return RsaUtil.encrypt(data, publicKey);
        }
        String str = null;
        try {
            str = Sm2Util.encrypt(publicKey, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public String decryptByPrivateKey(String data, PrivateKey privateKey) {
        if (this.type == Type.RSA) {
            return RsaUtil.decrypt(data, privateKey);
        }
        String str = null;
        try {
            str = Sm2Util.decrypt(privateKey, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public String decryptByPrivateKey(String data, String privateKey) {
        if (this.type == Type.RSA) {
            return RsaUtil.decrypt(data, privateKey);
        }
        return Sm2Util.decrypt(privateKey, data);
    }

    public String signByPrivateKey(String data, PrivateKey privateKey) {
        if (this.type == Type.RSA) {
            return RsaUtil.sign(privateKey, data);
        }
        String str = null;
        try {
            str = Sm2Util.sign(privateKey, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public String signByPrivateKey(String data, String privateKeyStr) {
        if (this.type == Type.RSA) {
            return RsaUtil.sign(privateKeyStr, data);
        }
        String str = null;
        try {
            str = Sm2Util.sign(privateKeyStr, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public boolean verifyByPublicKey(String data, String signature, String publickey) {
        if (this.type == Type.RSA) {
            return RsaUtil.verify(publickey, signature, data);
        }
        boolean result = false;
        try {
            result = Sm2Util.verify(publickey, signature, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean verifyByPublicKey(String data, String sin_data, PublicKey publicKey) {
        if (this.type == Type.RSA) {
            return RsaUtil.verify(publicKey, sin_data, data);
        }
        return Sm2Util.verify(publicKey, sin_data, data);
    }

    public String getPublicKeyStringByCert(String certPath) throws Exception {
        if (this.type == Type.RSA) {
            return RSAKeyStoreUtil.getPublicKeyStr(certPath);
        }
        return RSAKeyStoreUtil.getPublicKeyStr(certPath);
    }

    public PublicKey getPublicKeyByCert(String certPath) throws Exception {
        if (this.type == Type.RSA) {
            return RSAKeyStoreUtil.getPublicKeyByCert(certPath);
        }
        return null;
    }

    public String getPublicKeyStringByStore(KeyStore keyStore, String ksPass, String alias) throws Exception {
        X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
        PublicKey publicKey = cert.getPublicKey();
        String publicKeystr = Base64.getEncoder().encodeToString(publicKey.getEncoded());
        return publicKeystr;
    }

    public PublicKey getPublicKeyByStore(String ksPath, String ksPass, String alias) throws Exception {
        if (this.type == Type.RSA) {
            return RSAKeyStoreUtil.getPublicKeyByKeyStore(ksPath, alias, ksPass);
        }
        return null;
    }

    public String getPrivateKeyStringByKeyStore(KeyStore keyStore, String ksPasswd, String alias) throws Exception {
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, ksPasswd.toCharArray());
        String privateKeystr = Base64.getEncoder().encodeToString(privateKey.getEncoded());
        return privateKeystr;
    }

    public PrivateKey getPrivateKeyByKeyStore(String path, String storePass, String alias) throws Exception {
        if (this.type == Type.RSA) {
            return RSAKeyStoreUtil.getPrivateKey(path, alias, storePass);
        }
        return null;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Key newKeyInstall() {
        Key key = new Key();
        return key;
    }

    public static enum Type {
        SM,
        RSA;

    }
}

