/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cipher.rsa;

import cn.tdchain.cipher.utils.ByteUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class ShaUtil {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static ThreadLocal<Keccak.DigestKeccak> digestThreadLocal = new ThreadLocal();

    private ShaUtil() {
    }

    public static String hash(String text) {
        byte[] digest = null;
        byte[] input = text.getBytes(UTF8);
        digest = ShaUtil.sha3(input, 0, input.length);
        return ByteUtils.byteToHex(digest);
    }

    public static byte[] hash(byte[] input) {
        return ShaUtil.sha3(input, 0, input.length);
    }

    private static byte[] sha3(byte[] input, int offset, int length) {
        Keccak.DigestKeccak kecc = digestThreadLocal.get();
        if (kecc == null) {
            kecc = new Keccak.Digest256();
            digestThreadLocal.set(kecc);
        }
        kecc.update(input, offset, length);
        return kecc.digest();
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

