/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cipher.sm;

import cn.tdchain.cipher.utils.StringUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;

public final class Sm2Util {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final String EC = "EC";
    private static final String SM2P256V1 = "sm2p256v1";

    private Sm2Util() {
    }

    public static KeyPair generateSm2KeyPair() throws Exception {
        KeyPairGenerator g = KeyPairGenerator.getInstance(EC, "BC");
        g.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec(SM2P256V1), new SecureRandom());
        return g.generateKeyPair();
    }

    public static PrivateKey getPrivateKey(String privateKeyStr) throws Exception {
        if (StringUtils.isBlank(privateKeyStr)) {
            throw new NullPointerException();
        }
        byte[] keyBytes = Base64.getDecoder().decode(privateKeyStr);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(EC, "BC");
        return keyFactory.generatePrivate(pkcs8KeySpec);
    }

    public static PublicKey getPublicKey(String publicKeyStr) throws Exception {
        if (StringUtils.isBlank(publicKeyStr)) {
            throw new NullPointerException();
        }
        byte[] keyBytes = Base64.getDecoder().decode(publicKeyStr);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(EC, "BC");
        return keyFactory.generatePublic(keySpec);
    }

    public static String encrypt(PublicKey publicKey, String src) throws Exception {
        if (StringUtils.isBlank(src) || publicKey == null) {
            throw new NullPointerException();
        }
        byte[] srcData = src.getBytes(UTF8);
        if (publicKey instanceof BCECPublicKey) {
            BCECPublicKey localECPublicKey = (BCECPublicKey)publicKey;
            ECParameterSpec localECParameterSpec = localECPublicKey.getParameters();
            ECDomainParameters localECDomainParameters = new ECDomainParameters(localECParameterSpec.getCurve(), localECParameterSpec.getG(), localECParameterSpec.getN());
            ECPublicKeyParameters publiceyParam = new ECPublicKeyParameters(localECPublicKey.getQ(), localECDomainParameters);
            SM2Engine engine = new SM2Engine();
            ParametersWithRandom pwr = new ParametersWithRandom((CipherParameters)publiceyParam, new SecureRandom());
            engine.init(true, (CipherParameters)pwr);
            byte[] data = engine.processBlock(srcData, 0, srcData.length);
            return Base64.getEncoder().encodeToString(data);
        }
        return src;
    }

    public static String decrypt(PrivateKey privateKey, String src) throws Exception {
        if (StringUtils.isBlank(src) || privateKey == null) {
            throw new NullPointerException();
        }
        byte[] srcData = Base64.getDecoder().decode(src);
        if (privateKey instanceof BCECPrivateKey) {
            BCECPrivateKey localECPrivateKey = (BCECPrivateKey)privateKey;
            ECParameterSpec localECParameterSpec = localECPrivateKey.getParameters();
            ECDomainParameters localECDomainParameters = new ECDomainParameters(localECParameterSpec.getCurve(), localECParameterSpec.getG(), localECParameterSpec.getN());
            ECPrivateKeyParameters prikeyParam = new ECPrivateKeyParameters(localECPrivateKey.getD(), localECDomainParameters);
            SM2Engine engine = new SM2Engine();
            engine.init(false, (CipherParameters)prikeyParam);
            byte[] data = engine.processBlock(srcData, 0, srcData.length);
            return Base64.getEncoder().encodeToString(data);
        }
        return src;
    }

    public static String sign(PrivateKey privateKey, String src) throws Exception {
        if (StringUtils.isBlank(src) || privateKey == null) {
            throw new NullPointerException();
        }
        byte[] srcData = src.getBytes(UTF8);
        if (privateKey instanceof BCECPrivateKey) {
            BCECPrivateKey localECPrivateKey = (BCECPrivateKey)privateKey;
            ECParameterSpec localECParameterSpec = localECPrivateKey.getParameters();
            ECDomainParameters localECDomainParameters = new ECDomainParameters(localECParameterSpec.getCurve(), localECParameterSpec.getG(), localECParameterSpec.getN());
            ECPrivateKeyParameters prikeyParam = new ECPrivateKeyParameters(localECPrivateKey.getD(), localECDomainParameters);
            SM2Signer signer = new SM2Signer();
            ParametersWithRandom pwr = new ParametersWithRandom((CipherParameters)prikeyParam, new SecureRandom());
            signer.init(true, (CipherParameters)pwr);
            signer.update(srcData, 0, srcData.length);
            byte[] data = signer.generateSignature();
            return Base64.getEncoder().encodeToString(data);
        }
        return src;
    }

    public static boolean verify(PublicKey publicKey, String sign, String src) {
        if (StringUtils.isBlank(src) || StringUtils.isBlank(sign) || publicKey == null) {
            throw new NullPointerException();
        }
        if (publicKey instanceof BCECPublicKey) {
            BCECPublicKey localECPublicKey = (BCECPublicKey)publicKey;
            ECParameterSpec localECParameterSpec = localECPublicKey.getParameters();
            ECDomainParameters localECDomainParameters = new ECDomainParameters(localECParameterSpec.getCurve(), localECParameterSpec.getG(), localECParameterSpec.getN());
            ECPublicKeyParameters publiceyParam = new ECPublicKeyParameters(localECPublicKey.getQ(), localECDomainParameters);
            SM2Signer signer = new SM2Signer();
            signer.init(false, (CipherParameters)publiceyParam);
            byte[] srcData = src.getBytes(UTF8);
            signer.update(srcData, 0, srcData.length);
            return signer.verifySignature(Base64.getDecoder().decode(sign));
        }
        return false;
    }

    public static String encrypt(String publicKey, String data) {
        String str = null;
        try {
            PublicKey pKey = Sm2Util.getPublicKey(publicKey);
            str = Sm2Util.encrypt(pKey, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public static String decrypt(String privateKey, String data) {
        String str = null;
        try {
            PrivateKey pKey = Sm2Util.getPrivateKey(privateKey);
            str = Sm2Util.decrypt(pKey, data);
            str = StringUtils.newStr(Base64.getDecoder().decode(str));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public static String sign(String privateKeyStr, String data) {
        String str = null;
        try {
            PrivateKey pKey = Sm2Util.getPrivateKey(privateKeyStr);
            str = Sm2Util.sign(pKey, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public static boolean verify(String publickey, String signature, String data) {
        boolean result = false;
        try {
            PublicKey pKey = Sm2Util.getPublicKey(publickey);
            result = Sm2Util.verify(pKey, signature, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

