/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.net;

import io.netty.channel.Channel;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.smartboot.socket.transport.AioSession;

public class ConnectionCount {
    private final ConcurrentHashMap<String, ArrayList> connectionMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, OUKey> clientKeyMap = new ConcurrentHashMap();
    private static final ConnectionCount connectionCount = new ConnectionCount();

    private ConnectionCount() {
        ScheduledExecutorService exeService = Executors.newSingleThreadScheduledExecutor();
        exeService.scheduleAtFixedRate(() -> {
            try {
                this.connectionMap.forEach((k, v) -> {
                    Iterator iterator = v.iterator();
                    while (iterator.hasNext()) {
                        AioSession session;
                        Object next = iterator.next();
                        if (next instanceof Channel) {
                            Channel channel = (Channel)next;
                            if (channel.isActive()) continue;
                            iterator.remove();
                            continue;
                        }
                        if (next instanceof Socket) {
                            Socket socket = (Socket)next;
                            if (!socket.isClosed()) continue;
                            iterator.remove();
                            continue;
                        }
                        if (!(next instanceof AioSession) || !(session = (AioSession)next).isInvalid()) continue;
                        iterator.remove();
                    }
                    if (v.isEmpty()) {
                        this.connectionMap.remove(k);
                        this.clientKeyMap.remove(k);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public static ConnectionCount newInstance() {
        return connectionCount;
    }

    public synchronized void handleConnection(String conId, String ckey, String orgName, Object obj) {
        ArrayList<Object> valueList;
        if (!this.clientKeyMap.containsKey(conId)) {
            OUKey ouKey = new OUKey();
            ouKey.clientKey = ckey;
            ouKey.ou = orgName;
            this.clientKeyMap.put(conId, ouKey);
        }
        if ((valueList = this.connectionMap.get(conId)) != null) {
            valueList.add(obj);
        } else {
            valueList = new ArrayList<Object>();
            valueList.add(obj);
            this.connectionMap.put(conId, valueList);
        }
    }

    public synchronized boolean checkSingle(String connid, String clientKey) {
        Set<Map.Entry<String, OUKey>> entries = this.clientKeyMap.entrySet();
        for (Map.Entry<String, OUKey> next : entries) {
            String key = next.getKey();
            OUKey value = next.getValue();
            if (key.equals(connid) && value.clientKey.equals(clientKey)) {
                return true;
            }
            if (!key.equals(connid) && !value.clientKey.equals(clientKey)) continue;
            return false;
        }
        return true;
    }

    public String getOUbyPublickey(String ckey) {
        Set<Map.Entry<String, OUKey>> entries = this.clientKeyMap.entrySet();
        for (Map.Entry<String, OUKey> next : entries) {
            OUKey value = next.getValue();
            if (!value.clientKey.equals(ckey)) continue;
            return value.getOu();
        }
        return null;
    }

    public OUKey getOUKey(String connId) {
        if (connId == null) {
            return null;
        }
        return this.clientKeyMap.get(connId);
    }

    public ConcurrentHashMap<String, OUKey> getClientKeyMap() {
        return this.clientKeyMap;
    }

    public static class OUKey {
        private String clientKey;
        private String ou;
        private String account;

        public String getAccount() {
            return this.account;
        }

        public void setAccount(String account) {
            this.account = account;
        }

        public String getClientKey() {
            return this.clientKey;
        }

        public void setClientKey(String clientKey) {
            this.clientKey = clientKey;
        }

        public String getOu() {
            return this.ou;
        }

        public void setOu(String ou) {
            this.ou = ou;
        }
    }
}

