/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.net.aio;

import cn.tdchain.cipher.Cipher;
import cn.tdchain.cipher.Key;
import cn.tdchain.jbcc.JbccTimeOutException;
import cn.tdchain.jbcc.PBFT;
import cn.tdchain.jbcc.ParameterException;
import cn.tdchain.jbcc.SoutUtil;
import cn.tdchain.jbcc.net.Net;
import cn.tdchain.jbcc.net.aio.AioRequest;
import cn.tdchain.jbcc.net.aio.AioResphone;
import cn.tdchain.jbcc.net.info.Node;
import cn.tdchain.jbcc.rpc.RPCMessage;
import cn.tdchain.jbcc.rpc.RPCResult;
import cn.tdchain.jbcc.rpc.aio.client.AioRpcClient;
import cn.tdchain.jbcc.rpc.aio.client.AioRpcClientPool;
import cn.tdchain.jbcc.rpc.aio.client.AioRpcResponseClient;
import cn.tdchain.jbcc.rpc.aio.client.AioRpcSynResponseClient;
import cn.tdchain.jbcc.rpc.aio.engage.AioPoolableRpcClientFactory;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class AioNet
implements Net {
    private HashSet<String> iptables;
    private Hashtable<String, Node> nodes = new Hashtable();
    private int serverPort;
    private Cipher cipher;
    private String token;
    private Key key;
    private String connectionId;
    private int minResult = 1;
    private int minOnlineNodes = 1;
    private int true_count = 0;
    private boolean status = true;
    private HashMap<String, AioTask> taskList = new HashMap();

    public AioNet(String[] iptables, int serverPort, Cipher cipher, String token, Key key, String connectionId) {
        this.iptables = new HashSet<String>(Arrays.asList(iptables));
        this.serverPort = serverPort;
        this.cipher = cipher;
        this.token = token;
        this.key = key;
        this.connectionId = connectionId;
        this.minResult = PBFT.getMinByCount(iptables.length);
    }

    @Override
    public void start() {
        this.asynGetNodesByIpTable();
        new Thread(() -> {
            while (this.status) {
                try {
                    if (SoutUtil.isOpenSout()) {
                        System.out.println("Net node size=" + this.nodes.size());
                        System.out.println("Net task size=" + this.taskList.size());
                    }
                    for (String id : this.nodes.keySet()) {
                        AioTask t;
                        block14: {
                            Node node = this.nodes.get(id);
                            if (SoutUtil.isOpenSout()) {
                                System.out.println("node id=" + node.getId() + "  serverip=" + node.serverIP() + "  status=" + (Object)((Object)node.getStatus()));
                            }
                            t = null;
                            t = this.taskList.get(id);
                            if (!node.getStatus().equals((Object)Node.NodeStatus.DIE)) {
                                if (t == null) {
                                    try {
                                        t = new AioTask(node.serverIP(), this.serverPort, this.cipher, this.token, this.key, this.connectionId, 3);
                                        t.start();
                                        this.taskList.put(id, t);
                                        break block14;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        continue;
                                    }
                                }
                                if (SoutUtil.isOpenSout()) {
                                    System.out.println("task id=" + id + "  status=" + t.status);
                                }
                            } else {
                                if (t != null && t.status) {
                                    t.stop();
                                    this.taskList.remove(id);
                                }
                                if (SoutUtil.isOpenSout()) {
                                    System.out.println("dead node id=" + node.getId());
                                }
                            }
                        }
                        if (t == null || t.status) continue;
                        t.stop();
                        this.taskList.remove(id);
                    }
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {}
            }
            this.taskList.forEach((k, v) -> v.stop());
        }, "aio-net-start").start();
    }

    @Override
    public void request(RPCMessage msg) {
        this.taskList.forEach((k, v) -> {
            if (v != null && ((AioTask)v).status) {
                msg.setTarget((String)k);
                v.addRequest(msg.clone());
            }
        });
    }

    @Override
    public List<RPCResult> resphone(String messageId, long timeOut) {
        ArrayList<RPCResult> r_list = new ArrayList<RPCResult>(this.minResult + 3);
        long start = System.currentTimeMillis();
        ArrayList task_list = new ArrayList(this.taskList.size() + 3);
        this.taskList.forEach((k, v) -> {
            if (v != null) {
                task_list.add(v);
            }
        });
        while (true) {
            task_list.forEach(v -> {
                RPCResult r;
                if (v != null && (r = v.poll(messageId)) != null) {
                    r_list.add(r);
                }
            });
            if (r_list.size() >= this.minResult) break;
            if (System.currentTimeMillis() - start > timeOut) {
                if (r_list.size() >= 1) {
                    if (!SoutUtil.isOpenSout()) break;
                    System.out.println("r_list.size()=" + r_list.size());
                    break;
                }
                throw new JbccTimeOutException("jbcc request timeout:" + timeOut);
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return r_list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTaskSize() {
        HashMap<String, AioTask> hashMap = this.taskList;
        synchronized (hashMap) {
            return this.taskList.size();
        }
    }

    @Override
    public int getMinNodeSize() {
        this.minOnlineNodes = 0;
        this.nodes.forEach((k, v) -> {
            if (v.getStatus() == Node.NodeStatus.METRONOMER) {
                ++this.minOnlineNodes;
            }
        });
        if (this.minOnlineNodes == 0) {
            this.minOnlineNodes = 1;
        }
        return PBFT.getMinByCount(this.minOnlineNodes);
    }

    @Override
    public void addNodeToNodes(Node node) {
        if (this.nodes.get(node.getId()) == null) {
            this.nodes.put(node.getId(), node);
        } else {
            Node n = this.nodes.get(node.getId());
            n.setStatus(node.getStatus());
        }
    }

    private void asynGetNodesByIpTable() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                HashMap<String, Boolean> flag = new HashMap<String, Boolean>();
                Iterator ip_i = AioNet.this.iptables.iterator();
                HashMap<String, AioRpcSynResponseClient> clients = new HashMap<String, AioRpcSynResponseClient>();
                while (ip_i.hasNext()) {
                    String ip = (String)ip_i.next();
                    if (ip == null || ip.length() <= 0) continue;
                    flag.put(ip, false);
                }
                while (AioNet.this.status) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ip) {
                        // empty catch block
                    }
                    Iterator server_i = flag.keySet().iterator();
                    while (server_i.hasNext()) {
                        String server = null;
                        try {
                            Node node;
                            String data;
                            RPCResult r;
                            AioRpcSynResponseClient client;
                            block12: {
                                server = (String)server_i.next();
                                boolean flag_v = (Boolean)flag.get(server);
                                if (flag_v) continue;
                                client = (AioRpcSynResponseClient)clients.get(server);
                                if (client == null) {
                                    try {
                                        client = new AioRpcSynResponseClient(new AioRpcClient(server, AioNet.this.serverPort, AioNet.this.token, AioNet.this.connectionId, AioNet.this.key.getLocalCertBase64String()));
                                        if (client.isActive()) {
                                            clients.put(server, client);
                                            break block12;
                                        }
                                        client.close();
                                        client = null;
                                    }
                                    catch (Exception e) {
                                        if (client == null) break;
                                        client.close();
                                        client = null;
                                    }
                                    break;
                                }
                            }
                            RPCMessage requesy_node = new RPCMessage();
                            requesy_node.setTarget(server);
                            requesy_node.setTargetType(RPCMessage.TargetType.REQUEST_NODE);
                            requesy_node.setSender(AioNet.this.connectionId);
                            String r_str = client.sendAndReturn(requesy_node.toJsonString(), 5000L);
                            if (r_str == null || (r = (RPCResult)JSONObject.parseObject((String)r_str, RPCResult.class)) == null || r.getType() != RPCResult.ResultType.resphone_node || (data = r.getEntity()) == null || (node = (Node)JSONObject.parseObject((String)data, Node.class)) == null) continue;
                            if (SoutUtil.isOpenSout()) {
                                System.out.println("\u521d\u6b21\u6536\u5230node=" + node.toJSONString());
                            }
                            AioNet.this.nodes.put(node.getId(), node);
                            client.close();
                            clients.remove(server);
                            flag.put(server, true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            break;
                        }
                    }
                    AioNet.this.true_count = 0;
                    flag.forEach((k, v) -> {
                        if (v.booleanValue()) {
                            AioNet.this.true_count++;
                        }
                    });
                    if (AioNet.this.true_count < AioNet.this.minResult) continue;
                    break;
                }
            }
        }, "aio-net-syn");
        t.setDaemon(true);
        t.start();
    }

    @Override
    public List<Node> getNodes() {
        return this.nodes.entrySet().stream().filter(en -> en.getValue() != null).map(en -> (Node)en.getValue()).collect(Collectors.toList());
    }

    @Override
    public void stop() {
        this.status = false;
    }

    public class AioTask {
        private boolean status = true;
        private AioRpcClientPool rpcPool;
        private AioRequest request;
        private AioResphone resphone;

        public AioTask(String serverHost, int serverPort, Cipher cipher, String token, Key key, String connectionId, int workerNum) {
            String serverPublicKey = null;
            try {
                GenericObjectPoolConfig config = new GenericObjectPoolConfig();
                config.setMaxTotal(16);
                config.setMaxIdle(8);
                this.rpcPool = new AioRpcClientPool(new AioPoolableRpcClientFactory(serverHost, serverPort, token, connectionId, key.getLocalCertBase64String(), this), config);
                AioRpcClient client = (AioRpcClient)this.rpcPool.borrowObject();
                serverPublicKey = client.getServerPublicKey();
                this.rpcPool.returnObject(client);
            }
            catch (SocketException e) {
                throw new ParameterException("get AioRpcClientPool SocketException, target ip=" + serverHost + "  :" + e.getMessage());
            }
            catch (IOException e) {
                throw new ParameterException("get AioRpcClientPool IOException, target ip=" + serverHost + "  :" + e.getMessage());
            }
            catch (Exception e) {
                throw new ParameterException("get AioRpcClientPool Exception, target ip=" + serverHost + "  :" + e.getMessage());
            }
            this.request = new AioRequest(this, serverHost, serverPort, cipher, token, key, connectionId, 3, serverPublicKey);
            this.resphone = new AioResphone(this, serverHost, connectionId, key, cipher, 3, serverPublicKey);
        }

        public void addRequest(RPCMessage msg) {
            if (this.status) {
                this.request.addRequest(msg);
            }
        }

        public RPCResult poll(String messageId) {
            return this.resphone.poll(messageId);
        }

        public boolean isStatus() {
            return this.status;
        }

        public void start() {
            this.status = true;
            this.request.start();
            this.resphone.start();
        }

        public void stop() {
            this.status = false;
            this.request.stop();
            this.resphone.stop();
            this.rpcPool.close();
            if (this.rpcPool.isClosed()) {
                this.rpcPool.clear();
            }
        }

        public AioRpcClient getClient() {
            try {
                return (AioRpcClient)this.rpcPool.borrowObject();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public <T> T getClient(Class<T> clazz) {
            if (clazz == AioRpcResponseClient.class) {
                AioRpcResponseClient aioRpcResponseClient = new AioRpcResponseClient(this.getClient());
                return (T)aioRpcResponseClient;
            }
            if (clazz == AioRpcSynResponseClient.class) {
                AioRpcSynResponseClient aioResClient = new AioRpcSynResponseClient(this.getClient());
                return (T)aioResClient;
            }
            return (T)this.getClient();
        }

        public void setStatus(boolean status) {
            this.status = status;
        }
    }
}

