/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.net.aio;

import cn.tdchain.cipher.Cipher;
import cn.tdchain.cipher.DataCipher;
import cn.tdchain.cipher.Key;
import cn.tdchain.jbcc.SoutUtil;
import cn.tdchain.jbcc.net.aio.AioNet;
import cn.tdchain.jbcc.rpc.RPCMessage;
import cn.tdchain.jbcc.rpc.aio.client.AioRpcClient;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;

public class AioRequest {
    private AioNet.AioTask task;
    private int workerNum = 3;
    private AioRequestPool pool;
    private String ip;
    private Cipher cipher;
    private String token;
    private Key key;
    private boolean status = true;
    private String connectionId;
    private String serverPublicKey = null;
    int error_num = 0;

    public AioRequest(AioNet.AioTask task, String serverHost, int serverPort, Cipher cipher, String token, Key key, String connectionId, int workerNum, String serverPublicKey) {
        this.task = task;
        this.connectionId = connectionId;
        this.key = key;
        this.token = token;
        this.cipher = cipher;
        this.ip = serverHost;
        if (workerNum > this.workerNum) {
            this.workerNum = workerNum;
        }
        this.serverPublicKey = serverPublicKey;
        this.pool = new AioRequestPool();
    }

    public void start() {
        this.pool.start();
        final long wait_time = 50L;
        for (int i = 0; i < this.workerNum; ++i) {
            new Thread(new Runnable(){

                private int close(int error_num, AioRpcClient client, Exception e) {
                    ++error_num;
                    if (client != null) {
                        client.close();
                    }
                    return error_num;
                }

                @Override
                public void run() {
                    AioRpcClient client = AioRequest.this.task.getClient();
                    while (AioRequest.this.status) {
                        List<RPCMessage> msgList = AioRequest.this.pool.getMsgList(1000);
                        if (msgList.size() > 0) {
                            RPCMessage batch_msg = new RPCMessage();
                            batch_msg.setTarget(AioRequest.this.ip);
                            batch_msg.setTargetType(RPCMessage.TargetType.BATCH_REQUEST);
                            batch_msg.setSender(AioRequest.this.connectionId);
                            batch_msg.setMsg(JSONObject.toJSONString(msgList));
                            DataCipher data = new DataCipher(UUID.randomUUID().toString(), batch_msg.getMsg(), AioRequest.this.key.getPrivateKey(), AioRequest.this.serverPublicKey, AioRequest.this.cipher);
                            batch_msg.setMsg(JSON.toJSONString((Object)data));
                            try {
                                if (client == null) {
                                    client = AioRequest.this.task.getClient();
                                }
                                client.send(batch_msg.toJsonString());
                                AioRequest.this.error_num = 0;
                            }
                            catch (Exception e) {
                                AioRequest.this.error_num = this.close(AioRequest.this.error_num, client, e);
                            }
                            if (AioRequest.this.error_num > 5) {
                                if (SoutUtil.isOpenSout()) {
                                    System.out.println("request task \u88ab\u9500\u6bc1");
                                }
                                AioRequest.this.task.stop();
                            }
                        }
                        try {
                            Thread.sleep(wait_time);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }).start();
        }
    }

    public void addRequest(RPCMessage msg) {
        if (this.status) {
            this.pool.add(msg);
        }
    }

    public void stop() {
        this.status = false;
        this.pool.stop();
    }

    public class AioRequestPool {
        private boolean status = true;
        private LinkedBlockingQueue<RPCMessage> queue = new LinkedBlockingQueue();

        public void add(RPCMessage msg) {
            if (this.status) {
                this.queue.add(msg);
            }
        }

        public List<RPCMessage> getMsgList(int maxSize) {
            ArrayList<RPCMessage> msgList = new ArrayList<RPCMessage>();
            for (int i = 0; i < maxSize; ++i) {
                RPCMessage msg = this.queue.poll();
                if (msg == null) continue;
                msgList.add(msg);
            }
            return msgList;
        }

        public void start() {
            this.status = true;
        }

        public void stop() {
            this.status = false;
        }
    }
}

