/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.aio.client;

import cn.tdchain.cipher.rsa.AesUtil;
import cn.tdchain.jbcc.TimerUtil;
import cn.tdchain.jbcc.rpc.aio.engage.FixedLengthProtocol;
import cn.tdchain.jbcc.rpc.aio.engage.HandShakeStatus;
import cn.tdchain.jbcc.rpc.aio.engage.StringClientProcessor;
import cn.tdchain.jbcc.rpc.aio.handler.AioAuthClientHandler;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.transport.AioQuickClient;
import org.smartboot.socket.transport.AioSession;

public class AioRpcClient {
    private String serverPublicKey = null;
    private String token = null;
    private AioQuickClient<String> aioQuickClient;
    private AioSession<String> aioSession;
    private StringClientProcessor stringClientProcessor = new StringClientProcessor();
    private String connectionId;

    public AioRpcClient(String address, int port, String token, String connectionId, String clientPublicKey) throws InterruptedException, ExecutionException, IOException {
        AioSession start;
        this.aioQuickClient = new AioQuickClient(address, port, (Protocol)new FixedLengthProtocol(), (MessageProcessor)this.stringClientProcessor);
        this.aioSession = start = this.aioQuickClient.start();
        this.connectionId = connectionId;
        AioAuthClientHandler aioAuthClientHandler = new AioAuthClientHandler(token, connectionId, clientPublicKey);
        this.stringClientProcessor.getPipline().addLast(aioAuthClientHandler);
        this.token = token;
        this.connect();
    }

    private AioSession<String> connect() {
        try {
            String uuid = UUID.randomUUID().toString();
            String encode = AesUtil.encrypt(uuid, this.token);
            AioAuthClientHandler handler = (AioAuthClientHandler)this.stringClientProcessor.pipline.getHandler(AioAuthClientHandler.class);
            handler.getHandshakerMap().put(HandShakeStatus.AUTH, uuid);
            this.aioSession.write((Object)encode);
            String serverPublickey = TimerUtil.exec(100L, 50, () -> {
                String serverPublicKey = handler.getServerPublicKey();
                return serverPublicKey;
            });
            if (serverPublickey == null) {
                this.aioSession.close();
                return null;
            }
            this.serverPublicKey = serverPublickey;
            this.stringClientProcessor.pipline.remove(AioAuthClientHandler.class);
            return this.aioSession;
        }
        catch (IOException e) {
            this.close();
            e.printStackTrace();
            return null;
        }
    }

    public void close() {
        if (this.aioQuickClient != null) {
            this.aioQuickClient.shutdown();
        }
    }

    public void send(String msg) {
        try {
            this.aioSession.write((Object)msg);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isActive() {
        return !this.aioSession.isInvalid();
    }

    public void setServerPublicKey(String serverPublicKey) {
        this.serverPublicKey = serverPublicKey;
    }

    public AioSession<String> getAioSession() {
        return this.aioSession;
    }

    public void setAioSession(AioSession<String> aioSession) {
        this.aioSession = aioSession;
    }

    public String getServerPublicKey() {
        return this.serverPublicKey;
    }

    public StringClientProcessor getStringClientProcessor() {
        return this.stringClientProcessor;
    }

    public void setStringClientProcessor(StringClientProcessor stringClientProcessor) {
        this.stringClientProcessor = stringClientProcessor;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }
}

