/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.aio.engage;

import cn.tdchain.jbcc.rpc.aio.server.AioRpcServer;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.smartboot.socket.transport.AioSession;

public class AioThreadResponseHandler {
    private static AioThreadResponseHandler aioThreadResponseHandler = null;
    private Map<AioSession, String> channelMap = new ConcurrentHashMap<AioSession, String>();
    private static ScheduledExecutorService scheduledExecutorService = null;

    private AioThreadResponseHandler() {
        scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        scheduledExecutorService.scheduleAtFixedRate(() -> this.channelMap.forEach((k, v) -> {
            if (!k.isInvalid()) {
                String sendPublicKey = AioRpcServer.getStringServerProcessor().getClientKeyMap().get(k);
                String result = AioRpcServer.getStringServerProcessor().getAioRpcServer().getHandler().getResultMapByConnectionId((String)v, sendPublicKey);
                if (result != null) {
                    try {
                        k.write((Object)result);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                this.channelMap.remove(k);
            }
        }), 0L, 30L, TimeUnit.MILLISECONDS);
    }

    public void handle(AioSession session, String connId) {
        if (!this.channelMap.containsKey(session)) {
            this.channelMap.put(session, connId);
        }
    }

    public static AioThreadResponseHandler singleInstance() {
        if (aioThreadResponseHandler == null) {
            aioThreadResponseHandler = new AioThreadResponseHandler();
        }
        return aioThreadResponseHandler;
    }

    public void close() {
        if (scheduledExecutorService != null) {
            scheduledExecutorService.shutdownNow();
        }
    }
}

