/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.aio.engage;

import cn.tdchain.jbcc.rpc.aio.handler.InHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.smartboot.socket.transport.AioSession;

public class HandlerPipline {
    List<HandlerContext> handlerContexts = new ArrayList<HandlerContext>();
    private final HandlerContext head = new HandlerContext();
    private final HandlerContext tail = new HandlerContext();

    public HandlerPipline() {
        this.head.pipline = this;
        this.tail.pipline = this;
    }

    public synchronized void addLast(InHandler inHandler) {
        if (inHandler == null) {
            return;
        }
        boolean b = this.handlerContexts.stream().anyMatch(h -> h.getHandler().getClass() == inHandler.getClass());
        if (b) {
            throw new RuntimeException("\u5df2\u5b58\u5728:" + inHandler.getClass().getName());
        }
        HandlerContext context = new HandlerContext();
        context.pipline = this;
        context.handler = inHandler;
        HandlerContext pre = this.tail.getPre();
        if (pre == null) {
            this.head.next = context;
            this.tail.pre = context;
            context.pre = this.head;
            context.next = this.tail;
            this.handlerContexts.add(context);
            return;
        }
        pre.next = context;
        context.next = this.tail;
        this.tail.pre = context;
        this.handlerContexts.add(context);
    }

    public void process(AioSession<String> session, String msg) {
        if (this.head.aioSession == null) {
            this.head.setAioSession(session);
        }
        this.head.fireChannelRead(this.head, msg);
    }

    public InHandler getHandler(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Optional<HandlerContext> first = this.handlerContexts.stream().filter(h -> h.getHandler().getClass() == clazz).findFirst();
        if (first.isPresent()) {
            return first.get().getHandler();
        }
        return null;
    }

    public synchronized void remove(InHandler inHandler) {
        if (inHandler == null) {
            return;
        }
        this.remove(inHandler.getClass());
    }

    public synchronized void remove(Class clazz) {
        if (clazz == null) {
            return;
        }
        for (HandlerContext context : this.handlerContexts) {
            if (context.getHandler().getClass() != clazz || context == this.tail || context == this.head) continue;
            HandlerContext pre = context.getPre();
            HandlerContext next = context.next;
            pre.next = next;
            next.pre = pre;
            this.handlerContexts.remove(context);
            break;
        }
    }

    public static class HandlerContext {
        private HandlerPipline pipline;
        private HandlerContext next;
        private HandlerContext pre;
        private AioSession aioSession;
        private InHandler handler;

        private HandlerContext() {
        }

        public void fireChannelRead(HandlerContext context, Object msg) {
            HandlerContext next = context.next;
            next.setAioSession(context.getAioSession());
            next.channelRead(next, msg);
        }

        private void channelRead(HandlerContext context, Object msg) {
            InHandler handler = context.getHandler();
            if (handler != null) {
                try {
                    handler.channelRead(context, msg);
                }
                catch (Exception e) {
                    handler.exceptionCaught(context, e);
                }
            }
        }

        public void fireExceptionCaught(HandlerContext context, Exception e) {
            HandlerContext next = context.next;
            next.setAioSession(context.getAioSession());
            next.exceptionCaught(next, e);
        }

        public void exceptionCaught(HandlerContext context, Exception e) {
            InHandler handler = context.getHandler();
            if (handler != null) {
                handler.exceptionCaught(context, e);
            }
        }

        public HandlerPipline getPipline() {
            return this.pipline;
        }

        public void setPipline(HandlerPipline pipline) {
            this.pipline = pipline;
        }

        public HandlerContext getPre() {
            return this.pre;
        }

        public void setPre(HandlerContext pre) {
            this.pre = pre;
        }

        public InHandler getHandler() {
            return this.handler;
        }

        public void setHandler(InHandler handler) {
            this.handler = handler;
        }

        public AioSession getAioSession() {
            return this.aioSession;
        }

        public void setAioSession(AioSession aioSession) {
            this.aioSession = aioSession;
        }

        public void close() {
            if (this.aioSession != null) {
                this.aioSession.close();
            }
        }

        public void write(Object msg) throws IOException {
            if (this.aioSession != null) {
                this.aioSession.write(msg);
            }
        }
    }
}

