/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.aio.engage;

import cn.tdchain.jbcc.rpc.aio.engage.AioSessionCache;
import cn.tdchain.jbcc.rpc.aio.engage.HandlerPipline;
import cn.tdchain.jbcc.rpc.aio.handler.InHandler;
import java.util.concurrent.ConcurrentHashMap;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.transport.AioSession;

public abstract class ServerPiplineProcessor<T>
implements MessageProcessor<T> {
    private final ConcurrentHashMap<AioSession, HandlerPipline> piplineMap = AioSessionCache.getPiplineMap();
    private final ConcurrentHashMap<AioSession, String> clientKeyMap = AioSessionCache.getClientKeyMap();
    private final ConcurrentHashMap<Class<? extends InHandler>, InHandler> handlerPool = new ConcurrentHashMap();

    public synchronized void addLastHandler(AioSession session, InHandler handler) {
        HandlerPipline handlerPipline = this.piplineMap.get(session);
        if (handlerPipline != null) {
            handlerPipline.addLast(handler);
        } else {
            HandlerPipline pip = new HandlerPipline();
            pip.addLast(handler);
            this.piplineMap.put(session, pip);
        }
    }

    public synchronized void addLastHandler(AioSession session, Class<? extends InHandler> clazz) {
        InHandler handler = null;
        try {
            handler = this.handlerPool.containsKey(clazz) ? this.handlerPool.get(clazz) : clazz.newInstance();
            this.handlerPool.put(clazz, handler);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5b9e\u4f8b\u5316inHandler\u5931\u8d25:" + e.getMessage());
        }
        this.addLastHandler(session, handler);
    }

    public synchronized void removeHandler(AioSession session, Class clazz) {
        HandlerPipline handlerPipline = this.piplineMap.get(session);
        if (handlerPipline != null) {
            handlerPipline.remove(clazz);
        }
    }

    public synchronized void addKey(AioSession session, String key) {
        this.clientKeyMap.put(session, key);
    }

    public synchronized void removeKey(AioSession session) {
        this.clientKeyMap.remove(session);
    }

    public void handle(AioSession session, String msg) throws Exception {
        HandlerPipline handlerPipline = this.piplineMap.get(session);
        if (handlerPipline != null) {
            handlerPipline.process((AioSession<String>)session, msg);
        }
    }

    public synchronized void remove(AioSession session) {
        this.piplineMap.remove(session);
    }

    public ConcurrentHashMap<AioSession, String> getClientKeyMap() {
        return this.clientKeyMap;
    }
}

