/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.aio.handler;

import cn.tdchain.cipher.rsa.AesUtil;
import cn.tdchain.jbcc.rpc.aio.engage.HandShakeStatus;
import cn.tdchain.jbcc.rpc.aio.engage.HandlerPipline;
import cn.tdchain.jbcc.rpc.aio.handler.InHandler;
import java.util.HashMap;
import java.util.Map;

public class AioAuthClientHandler
implements InHandler<String> {
    private Map<HandShakeStatus, String> handshakerMap = new HashMap<HandShakeStatus, String>();
    private String token;
    private String publicKey;
    private String serverPublicKey;
    private String connectionId;

    public AioAuthClientHandler(String token, String connectionId, String publicKey) {
        this.token = token;
        this.connectionId = connectionId;
        this.publicKey = publicKey;
    }

    @Override
    public void channelRead(HandlerPipline.HandlerContext context, Object msg) throws Exception {
        String authSequence = (String)msg;
        if (!this.handshakerMap.containsKey((Object)HandShakeStatus.HAND_2)) {
            String data = this.handshakerMap.get((Object)HandShakeStatus.AUTH);
            String decode = authSequence.split(";")[0];
            String encode = authSequence.split(";")[1];
            if (data.equals(decode) && (data = AesUtil.decrypt(encode, this.token)) != null) {
                this.handshakerMap.put(HandShakeStatus.HAND_2, HandShakeStatus.HAND_2.name());
                context.write(data);
            }
            return;
        }
        if (!this.handshakerMap.containsKey((Object)HandShakeStatus.HAND_3)) {
            this.handshakerMap.put(HandShakeStatus.SERVER_PUBLIC_KEY, authSequence);
            this.handshakerMap.put(HandShakeStatus.HAND_3, HandShakeStatus.HAND_3.name());
            String keyAndConnectionId = this.publicKey + ";" + this.connectionId;
            context.write(keyAndConnectionId);
            this.serverPublicKey = authSequence;
        }
    }

    @Override
    public void exceptionCaught(HandlerPipline.HandlerContext context, Throwable cause) {
    }

    public Map<HandShakeStatus, String> getHandshakerMap() {
        return this.handshakerMap;
    }

    public void setHandshakerMap(Map<HandShakeStatus, String> handshakerMap) {
        this.handshakerMap = handshakerMap;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getServerPublicKey() {
        return this.serverPublicKey;
    }

    public void setServerPublicKey(String serverPublicKey) {
        this.serverPublicKey = serverPublicKey;
    }
}

