/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.aio.handler;

import cn.tdchain.cipher.rsa.AesUtil;
import cn.tdchain.cipher.rsa.RsaUtil;
import cn.tdchain.jbcc.net.ConnectionCount;
import cn.tdchain.jbcc.rpc.aio.engage.AioSessionCache;
import cn.tdchain.jbcc.rpc.aio.engage.HandShakeStatus;
import cn.tdchain.jbcc.rpc.aio.engage.HandlerPipline;
import cn.tdchain.jbcc.rpc.aio.engage.StringServerProcessor;
import cn.tdchain.jbcc.rpc.aio.handler.AioServerHandler;
import cn.tdchain.jbcc.rpc.aio.handler.InHandler;
import cn.tdchain.jbcc.rpc.aio.server.AioRpcServer;
import cn.tdchain.tdmsp.Msp;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.smartboot.socket.transport.AioSession;

public class AioAuthServerHandler
implements InHandler<String> {
    private ConcurrentHashMap<AioSession, Map<HandShakeStatus, String>> cmap = AioSessionCache.getCmap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void channelRead(HandlerPipline.HandlerContext context, Object msg) throws Exception {
        Map<HandShakeStatus, String> handshakeMap;
        String str = (String)msg;
        if (str == null || str.length() == 0) {
            context.close();
        }
        if (!this.cmap.containsKey(context.getAioSession())) {
            HashMap clientmap = new HashMap();
            this.cmap.put(context.getAioSession(), clientmap);
        }
        if (!(handshakeMap = this.cmap.get(context.getAioSession())).containsKey((Object)HandShakeStatus.HAND_1)) {
            String c_data = AesUtil.decrypt(str, AioRpcServer.getStringServerProcessor().getAioRpcServer().getToken());
            String s_data = UUID.randomUUID().toString();
            String s_r_data = c_data + ";" + AesUtil.encrypt(s_data, AioRpcServer.getStringServerProcessor().getAioRpcServer().getToken());
            handshakeMap.put(HandShakeStatus.AUTH, s_data);
            handshakeMap.put(HandShakeStatus.HAND_1, HandShakeStatus.HAND_1.name());
            context.write(s_r_data);
            return;
        }
        if (!handshakeMap.containsKey((Object)HandShakeStatus.HAND_2)) {
            String s_data = handshakeMap.get((Object)HandShakeStatus.AUTH);
            if (!s_data.equals(str)) return;
            handshakeMap.put(HandShakeStatus.HAND_2, HandShakeStatus.HAND_2.name());
            context.write(AioRpcServer.getStringServerProcessor().getAioRpcServer().getKey().getPublicKey());
            return;
        }
        if (!handshakeMap.containsKey((Object)HandShakeStatus.HAND_3)) {
            String[] splits = str.split(";");
            String clientCertBase64Str = splits[0];
            String connectId = splits[1];
            X509Certificate clientCert = Msp.base64StringToCert(clientCertBase64Str);
            boolean leg = Msp.validateCert(Msp.base64StringToCert(AioRpcServer.getStringServerProcessor().getAioRpcServer().getKey().getRootCertBase64String()), clientCert);
            if (!leg) throw new RuntimeException("aio shake  failed! Illegal certificate.");
            String clientPubliKey = RsaUtil.getPublicKey(clientCert.getPublicKey());
            handshakeMap.put(HandShakeStatus.CLIENT_PUBLIC_KEY, clientPubliKey);
            handshakeMap.put(HandShakeStatus.HAND_3, HandShakeStatus.HAND_3.name());
            String orgName = Msp.getOrganizationName(clientCert);
            if (!ConnectionCount.newInstance().checkSingle(connectId, clientPubliKey)) throw new RuntimeException("aio shake  failed! Illegal certificate. params");
            ConnectionCount.newInstance().handleConnection(connectId, clientPubliKey, orgName, context.getAioSession());
        }
        if (!handshakeMap.containsKey((Object)HandShakeStatus.CLIENT_PUBLIC_KEY)) return;
        StringServerProcessor stringServerProcessor = AioRpcServer.getStringServerProcessor();
        stringServerProcessor.getClientKeyMap().put(context.getAioSession(), handshakeMap.get((Object)HandShakeStatus.CLIENT_PUBLIC_KEY));
        stringServerProcessor.removeHandler(context.getAioSession(), AioAuthServerHandler.class);
        stringServerProcessor.addLastHandler(context.getAioSession(), AioServerHandler.class);
        this.cmap.remove(context.getAioSession());
    }

    @Override
    public void exceptionCaught(HandlerPipline.HandlerContext context, Throwable cause) {
        cause.printStackTrace();
        context.close();
    }

    public ConcurrentHashMap<AioSession, Map<HandShakeStatus, String>> getCmap() {
        return this.cmap;
    }
}

