/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.aio.handler;

import cn.tdchain.cipher.DataCipher;
import cn.tdchain.jbcc.SoutUtil;
import cn.tdchain.jbcc.net.aio.AioNet;
import cn.tdchain.jbcc.net.aio.AioResphone;
import cn.tdchain.jbcc.rpc.RPCResult;
import cn.tdchain.jbcc.rpc.aio.engage.HandlerPipline;
import cn.tdchain.jbcc.rpc.aio.handler.InHandler;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Map;

public class AioResponseClientHandler
implements InHandler<String> {
    private int errorNum = 0;
    private AioResphone aioResphone;
    private AioNet.AioTask task;

    @Override
    public void channelRead(HandlerPipline.HandlerContext context, Object msg) throws Exception {
        String message = (String)msg;
        RPCResult r = (RPCResult)JSONObject.parseObject((String)message, RPCResult.class);
        if (r != null && r.getType() == RPCResult.ResultType.batch_resphone) {
            String cipher_data = r.getEntity();
            DataCipher data = (DataCipher)JSONObject.parseObject((String)cipher_data, DataCipher.class);
            String data_str = data.getData(this.aioResphone.getKey().getPrivateKey(), this.aioResphone.getCipher());
            if (data_str == null) {
                return;
            }
            Map connectionMap = (Map)JSON.parseObject((String)data_str, (TypeReference)new TypeReference<Map<String, RPCResult>>(){}, (Feature[])new Feature[0]);
            if (connectionMap != null && connectionMap.size() > 0) {
                this.aioResphone.getPool().add(connectionMap);
            }
        }
        this.errorNum = 0;
    }

    @Override
    public void exceptionCaught(HandlerPipline.HandlerContext context, Throwable cause) {
        ++this.errorNum;
        if (SoutUtil.isOpenSout()) {
            System.out.println("\u6253\u5370:get an error times:" + this.errorNum);
        }
        cause.printStackTrace();
        if (this.errorNum >= 5) {
            this.errorNum = 0;
            if (this.task != null) {
                this.task.setStatus(false);
            }
        }
    }

    public int getErrorNum() {
        return this.errorNum;
    }

    public void setErrorNum(int errorNum) {
        this.errorNum = errorNum;
    }

    public AioResphone getAioResphone() {
        return this.aioResphone;
    }

    public void setAioResphone(AioResphone aioResphone) {
        this.aioResphone = aioResphone;
    }

    public AioNet.AioTask getTask() {
        return this.task;
    }

    public void setTask(AioNet.AioTask task) {
        this.task = task;
    }
}

