/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.io.server;

import cn.tdchain.cipher.Key;
import cn.tdchain.jbcc.rpc.MessageHandler;
import cn.tdchain.jbcc.rpc.RPCMessage;
import cn.tdchain.jbcc.rpc.RpcServer;
import cn.tdchain.jbcc.rpc.io.eclc.ClientSocket;
import cn.tdchain.jbcc.rpc.io.eclc.EclcServerSocket;
import cn.tdchain.jbcc.rpc.io.server.ExecutorUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.IOUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.SocketException;

public class IORpcServer
implements RpcServer {
    private ExecutorUtil executorUtil = new ExecutorUtil();
    private String token = "tiande@123456AbC";
    private int port = 18088;
    private MessageHandler handler = null;
    private Key key = null;

    public IORpcServer(int port, MessageHandler handler, String token, Key key) {
        this.port = port;
        this.handler = handler;
        this.token = token;
        this.key = key;
        this.executorUtil.initExecutor();
    }

    @Override
    public void startServer() {
        this.executorUtil.executor(new Runnable(){

            @Override
            public void run() {
                EclcServerSocket server = null;
                try {
                    server = new EclcServerSocket(IORpcServer.this.port, IORpcServer.this.token, IORpcServer.this.key);
                    boolean i = true;
                    while (true) {
                        ClientSocket socket = null;
                        try {
                            socket = server.accept2();
                            IORpcServer.this.executorUtil.executor(IORpcServer.this.getTask(socket));
                        }
                        catch (SocketException e) {
                            if (socket == null) continue;
                            IOUtils.close((Closeable)socket.getSocket());
                        }
                        catch (IOException e) {
                            if (socket == null) continue;
                            IOUtils.close((Closeable)socket.getSocket());
                        }
                        catch (Exception e) {
                            if (socket == null) continue;
                            IOUtils.close((Closeable)socket.getSocket());
                        }
                    }
                }
                catch (IOException e) {
                    IOUtils.close(server);
                    return;
                }
            }
        });
    }

    private Runnable getTask(final ClientSocket socket) {
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader br = null;
                BufferedWriter bwrite = null;
                try {
                    String line;
                    br = new BufferedReader(new InputStreamReader(socket.getSocket().getInputStream()));
                    bwrite = new BufferedWriter(new OutputStreamWriter(socket.getSocket().getOutputStream()));
                    while ((line = br.readLine()) != null) {
                        if (line.length() == 0) {
                            break;
                        }
                        String result = null;
                        RPCMessage msg = null;
                        try {
                            msg = (RPCMessage)JSONObject.parseObject((String)line, RPCMessage.class);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        String connectionId = msg.getSender();
                        if (RPCMessage.TargetType.BATCH_RESPHONE == msg.getTargetType()) {
                            Thread.currentThread().setPriority(10);
                            String sendPublicKey = socket.getClientPubliKey();
                            int index = 0;
                            while (true) {
                                if ((result = IORpcServer.this.handler.getResultMapByConnectionId(connectionId, sendPublicKey)) != null || ++index == 100) {
                                    index = 0;
                                    bwrite.write(result);
                                    bwrite.newLine();
                                    bwrite.flush();
                                }
                                try {
                                    Thread.sleep(30L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        try {
                            result = IORpcServer.this.handler.handler(msg, connectionId);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (result == null) continue;
                        bwrite.write(result);
                        bwrite.newLine();
                        bwrite.flush();
                    }
                }
                catch (SocketException socketException) {
                }
                catch (IOException iOException) {
                }
                finally {
                    IOUtils.close((Closeable)socket.getSocket());
                }
            }
        };
        return task;
    }
}

