/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.nio.handler;

import cn.tdchain.jbcc.rpc.RPCMessage;
import cn.tdchain.jbcc.rpc.nio.handler.NioThreadResponseHandler;
import cn.tdchain.jbcc.rpc.nio.server.NioRpcServer;
import com.alibaba.fastjson.JSONObject;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

@ChannelHandler.Sharable
public class NioServerHandler
extends ChannelInboundHandlerAdapter {
    private NioThreadResponseHandler nioThreadResponseHandler;
    private NioRpcServer nioRpcServer;

    public NioServerHandler(NioRpcServer nioRpcServer) {
        this.nioRpcServer = nioRpcServer;
        this.nioThreadResponseHandler = NioThreadResponseHandler.singleInstance(nioRpcServer);
    }

    public void channelRead(ChannelHandlerContext ctx, Object rmsg) throws Exception {
        String str = (String)rmsg;
        RPCMessage msg = (RPCMessage)JSONObject.parseObject((String)str, RPCMessage.class);
        String connectionId = msg.getSender();
        if (RPCMessage.TargetType.BATCH_RESPHONE == msg.getTargetType()) {
            this.nioThreadResponseHandler.handle(ctx.channel(), connectionId);
        } else {
            String result = this.nioRpcServer.getHandler().handler(msg, connectionId);
            if (result != null) {
                ctx.writeAndFlush((Object)result);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
    }

    public NioRpcServer getNioRpcServer() {
        return this.nioRpcServer;
    }

    public void setNioRpcServer(NioRpcServer nioRpcServer) {
        this.nioRpcServer = nioRpcServer;
    }
}

