/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain;

import cn.tdchain.cipher.rsa.Sha256Util;
import cn.tdchain.jbcc.BlockException;
import cn.tdchain.jbcc.MerkleUtil;
import cn.tdchain.jbcc.TransUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * Description: 天德区账本Block实体
 *
 * @author xiaoming
 * 2019年4月18日
 */
public class Block<T extends Trans> extends BlockHead {
    protected List<T> trans; // 交易列表

    public List<T> getTrans() {
        return trans;
    }

    public void setTrans(List<T> trans) {
        this.trans = trans;
    }

    /**
     * block自身检查,验证hash、merkle_tree是否正确
     */
    public void check() {
        // 1.验证 merkle_tree
        List<T> t_list = this.getTrans();
        if (t_list == null || t_list.size() == 0) {
            throw new BlockException("block list is null.");
        }

        List<String> blockHashList = new ArrayList<>(this.getCount());
        for (T trans : t_list) {
            String hash = TransUtil.getHash(trans);
            blockHashList.add(hash);//累加全部交易hash
        }

        String merkleRoot = MerkleUtil.getMerkleRoot(blockHashList);
        if (getMerkleRoot() == null || !merkleRoot.equals(getMerkleRoot())) {
            throw new BlockException("block merkle root error.");
        }

        // 2.验证 hash
        String hash = Sha256Util.hash(getMerkleRoot() + getPreHash() + getTimestamp());
        if (getHash() == null || !getHash().equals(hash)) {
            throw new BlockException("block hash error.");
        }
    }
}
