/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain;

import com.alibaba.fastjson.JSON;

/**
 * Description: 天德区账本BlockHead实体
 *
 * @author xiaoming
 * 2019年4月18日
 */
public class BlockHead {
    protected Long height;//块高度
    protected String hash;//块hash
    protected String preHash; // 前一个block的hash
    protected String merkleRoot;
    protected Long timestamp;
    protected String sign;//签名
    protected int count; // 交易数量

    /**
     * 创建者
     */
    protected String createrName;
    /**
     * 创建者ID
     */
    protected String createrId;

    public Long getHeight() {
        return height;
    }

    public void setHeight(Long height) {
        this.height = height;
    }

    public String getHash() {
        return hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getPreHash() {
        return preHash;
    }

    public void setPreHash(String preHash) {
        this.preHash = preHash;
    }

    public String getMerkleRoot() {
        return merkleRoot;
    }

    public void setMerkleRoot(String merkleRoot) {
        this.merkleRoot = merkleRoot;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getCreaterName() {
        return createrName;
    }

    public void setCreaterName(String createrName) {
        this.createrName = createrName;
    }

    public String getCreaterId() {
        return createrId;
    }

    public void setCreaterId(String createrId) {
        this.createrId = createrId;
    }

    public String toJsonString() {
        return JSON.toJSONString(this);
    }

}
