/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.bql;

import com.alibaba.fastjson.JSONObject;


/**
 * BlockChain Query Language, a query can have up to 10 Conditions, invalid exceeded.
 * datetime：2020-03-18 13:07
 * author：xiaoming
 */
public class BQL {
	/**
	 * 构建一个BlockChain Query Langage对象
	 */
	public BQL() {}
	
	/**
	 * Json string to a BQL object
	 * @param jsonStr
	 */
	public BQL(String jsonStr) {
		JSONObject jsonObject = JSONObject.parseObject(jsonStr);
		BQL bql = jsonObject.toJavaObject(jsonObject, BQL.class);
		this.setPage(bql.getPage());
		this.setCondition(bql.getCondition());
	}
	
	private Integer page = 1;//默认第一1页，一般情况下查询不超过30个交易结果的，都属于第一页
	
	private Condition condition = null;//查询的第一个条件对象，多个查询条件可以连接起来。
	
	public Integer getPage() {
		return page;
	}

	public void setPage(Integer page) {
		this.page = page;
	}

	public Condition getCondition() {
		return condition;
	}

	public void setCondition(Condition condition) {
		this.condition = condition;
	}
	
	public String toJSONString() {
		return JSONObject.toJSONString(this);
	}

    public Condition newCondition() {
    	return new Condition();
    }
    
    
	/**
	 * function：BQL 条件关系枚举
	 * datetime：2020-03-18 13:07
	 * author：xiaoming
	 */
	public enum Relationship{
		/**
		 * less 小于,如: new Condition("age", BQL.Relationship.less, 20);
		 */
		less,
		
		/**
		 * greater 大于,如: new Condition("age", BQL.Relationship.greater, 18);
		 */
		greater,
		
		/**
		 * equal 等于,如: new Condition("name", BQL.Relationship.equal, "abc");
		 */
		equal,
		
		/**
		 * no_equal 不等于,如: new Condition("age", BQL.Relationship.no_equal, 18);
		 */
		no_equal,
		
		/**
		 * like 模糊比配使用%,如: new Condition("name", BQL.Relationship.like, "abc%");
		 */
		like
	}

}
