/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.bql;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.fastjson.JSONObject;

import cn.tdchain.Trans;

/**
 * BlockChain Query Language Result
 * datetime：2020-03-18 13:07
 * author：xiaoming
 */
public class BQLResult {
	
	private int size = 0;//查询到的总结果数
	
	private int count = 0;//当前返回结果数
	
	private int page = 1;//当前返回第几页数据
	
	private List<? extends Trans> list = new ArrayList<Trans>(35);//当前返回交易集合
	
	
	
	public BQLResult() {}
	
	
	/**
	 * Json string to a BQLResult object
	 * @param jsonStr
	 */
	public BQLResult(String jsonStr) {
		JSONObject jsonObject = JSONObject.parseObject(jsonStr);
		BQLResult result = jsonObject.toJavaObject(jsonObject, BQLResult.class);
		this.setPage(result.getPage());
		this.setSize(result.getSize());
		this.setCount(result.getCount());
		this.setList(result.getList());
	}
	
    /**
     * @return size int 本次查询总条数
     */
	public int getSize() {
		return size;
	}

	public void setSize(int size) {
		this.size = size;
	}

	/**
	 * @return count int 本次实际返回条数，一次查询返回不会超过30条，否则系统会自动分页。
	 */
	public int getCount() {
		return count;
	}

	public void setCount(int count) {
		this.count = count;
	}
	
	/**
	 * @return page int 获取本次返回的页码坐标，页码坐标最小是：1 （俗称第一页）
	 */
	public int getPage() {
		return page;
	}

	public void setPage(int page) {
		this.page = page;
	}

	/**
	 * @return list List<Trans> 获取本次查询到的交易集合，长度不会超过30.
	 */
	public List<? extends Trans> getList() {
		return list;
	}

	public void setList(List<? extends Trans> list) {
		this.list = list;
	}
	
	public String toJsonString() {
		return JSONObject.toJSONString(this);
	}
	
}
