/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.bql;

import cn.tdchain.jbcc.bql.BQL.Relationship;

 /**
 * BQL 条件对象
 * datetime：2020-03-18 13:07
 * author：xiaoming
 */
public class Condition{
	
	private String name;//条件名称，如：age=18，age就只是这个name的值
	
	private Object value;//条件值，如：age=18，18就只是这个vaule的值
	
	private Relationship relationship;//条件name和vaule是关系类型：<   >   ==   !=   %
	
	private Condition or = null;//下一个或者的条件对象，相当于：||
	
	private Condition and = null;//下一个并且的条件对象，相当于：&&

	
	public Condition() {}
	
	/**
	 * 快速构建一个条件对象
	 * @param name 条件名称
	 * @param relationship 条件关系：等于、不等于、大于、小于、模糊
	 * @param value 条件值
	 */
	public Condition(String name, BQL.Relationship relationship, Object value) {
		this.name = name;
		this.relationship = relationship;
		this.value = value;
	}
	
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Object getValue() {
		return value;
	}

	public void setValue(Object value) {
		this.value = value;
	}

	public Relationship getRelationship() {
		return relationship;
	}

	public void setRelationship(Relationship relationship) {
		this.relationship = relationship;
	}

	public Condition getOr() {
		return or;
	}

	public void setOr(Condition or) {
		this.or = or;
	}

	public Condition getAnd() {
		return and;
	}

	public void setAnd(Condition and) {
		this.and = and;
	}
	
	
}

