/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain;

import cn.tdchain.BlockHead;
import cn.tdchain.Trans;
import cn.tdchain.cipher.rsa.Sha256Util;
import cn.tdchain.jbcc.BlockException;
import cn.tdchain.jbcc.MerkleUtil;
import cn.tdchain.jbcc.TransUtil;
import java.util.ArrayList;
import java.util.List;

public class Block<T extends Trans>
extends BlockHead {
    protected List<T> trans;

    public List<T> getTrans() {
        return this.trans;
    }

    public void setTrans(List<T> trans) {
        this.trans = trans;
    }

    public void check() {
        List<T> t_list = this.getTrans();
        if (t_list == null || t_list.size() == 0) {
            throw new BlockException("block list is null.");
        }
        ArrayList<String> blockHashList = new ArrayList<String>(this.getCount());
        for (Trans trans : t_list) {
            String hash = TransUtil.getHash(trans);
            blockHashList.add(hash);
        }
        String merkleRoot = MerkleUtil.getMerkleRoot(blockHashList);
        if (this.getMerkleRoot() == null || !merkleRoot.equals(this.getMerkleRoot())) {
            throw new BlockException("block merkle root error.");
        }
        String hash = Sha256Util.hash(this.getMerkleRoot() + this.getPreHash() + this.getTimestamp());
        if (this.getHash() == null || !this.getHash().equals(hash)) {
            throw new BlockException("block hash error.");
        }
    }
}

