/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain;

import cn.tdchain.TransHead;
import cn.tdchain.cipher.rsa.RsaUtil;
import cn.tdchain.cipher.utils.HashCheckUtil;
import cn.tdchain.cipher.utils.StringUtils;
import cn.tdchain.jbcc.DateUtils;
import cn.tdchain.jbcc.SQLCheckUtil;
import cn.tdchain.jbcc.SensitiveWordsUtil;
import cn.tdchain.jbcc.TransInfoException;
import cn.tdchain.jbcc.TransUtil;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class Trans
extends TransHead {
    protected String account;
    protected String data;
    protected Category category;
    protected Map<String, Long> keyVersionMap;
    protected Map<String, String> signMap;

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public Map<String, Long> getKeyVersionMap() {
        return this.keyVersionMap;
    }

    public void setKeyVersionMap(Map<String, Long> keyVersionMap) {
        this.keyVersionMap = keyVersionMap;
    }

    public Map<String, String> getSignMap() {
        return this.signMap;
    }

    public void setSignMap(Map<String, String> signMap) {
        this.signMap = signMap;
    }

    @Override
    @Deprecated
    public void upHash() {
        if (this.key == null || this.key.trim().length() == 0 || this.key.trim().length() > 255) {
            throw new TransInfoException("key is null or too long.");
        }
        if (StringUtils.isBlank(this.account)) {
            throw new TransInfoException("account is blank.");
        }
        if (this.timestamp == null) {
            this.setTimestamp(DateUtils.getCurrentTime());
        }
        if (this.hash != null && this.hash.length() > 0 && !this.hash.equals("null")) {
            this.preHash = this.hash;
        }
        this.hash = this.computHash(this);
    }

    public String computHash(Trans t) {
        return TransUtil.getTransHash(t);
    }

    @Override
    public void check() {
        this.check(false);
    }

    @Override
    public void check(boolean enableVerifySensitiveWorks) {
        TransUtil.verifyKey(this.getKey());
        if (HashCheckUtil.illegalCharacterCheck(this.type) || this.type != null && this.type.length() > 45) {
            throw new TransInfoException("type have Illegal character.");
        }
        if (SQLCheckUtil.checkSQLError(this.getKey())) {
            throw new TransInfoException("key have Illegal character.");
        }
        if (this.getData() == null || this.getData().trim().length() == 0 || this.getData().trim().getBytes().length > 65535) {
            throw new TransInfoException("data is null or too long, max byte size is 65535.");
        }
        if (HashCheckUtil.illegalCharacterCheck(this.data)) {
            throw new TransInfoException("data have Illegal character.");
        }
        if (this.category == null) {
            if (this.keyVersionMap != null) {
                throw new TransInfoException("category is null & keyVersionMap should be null");
            }
            if (this.signMap != null) {
                throw new TransInfoException("category is null & keyVersionMap should be null");
            }
        } else if (Category.contract == this.category) {
            if (this.version == null) {
                throw new TransInfoException("contract version none init");
            }
            if (this.keyVersionMap != null) {
                if (this.keyVersionMap.size() > 10) {
                    throw new TransInfoException("contract keyVersionMap size is limit to 10.");
                }
                this.keyVersionMap.forEach((k, v) -> TransUtil.verifyKey(k));
            }
            if (MapUtils.isNotEmpty(this.signMap)) {
                String thash = TransUtil.getTransHash(this);
                this.signMap.forEach((k, v) -> {
                    boolean verify = RsaUtil.verify(k, v, thash);
                    if (!verify) {
                        throw new TransInfoException("contract signMap sign error.");
                    }
                });
            }
        }
        if (!HashCheckUtil.hashCheck(this.hash)) {
            throw new TransInfoException("hash error:" + this.hash);
        }
        if (!HashCheckUtil.hashCheck(this.preHash) && !"".equals(this.preHash)) {
            throw new TransInfoException("pre hash error:" + this.preHash);
        }
        if (enableVerifySensitiveWorks) {
            this.checkSensitiveWords();
        }
        this.checkStartTime();
    }

    private void checkSensitiveWords() {
        String key = this.getKey();
        String data = this.getData();
        boolean isContains = SensitiveWordsUtil.containsSensitiveWords(key, SensitiveWordsUtil.MATCH_TYPE_MIN);
        if (isContains) {
            throw new TransInfoException("trans[key=" + key + "] contains sensitive words");
        }
        isContains = SensitiveWordsUtil.containsSensitiveWords(data, SensitiveWordsUtil.MATCH_TYPE_MIN);
        if (isContains) {
            throw new TransInfoException("trans[data=" + data + "] contains sensitive words");
        }
    }

    protected void checkStartTime() {
        Long differ_time = System.currentTimeMillis() - this.getTimestamp();
        if (differ_time > 6000L || differ_time < -6000L) {
            throw new TransInfoException("the trans out of time or timestamp is error.");
        }
    }

    public static enum Category {
        contract;

    }
}

