/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc;

import cn.tdchain.cipher.Cipher;
import cn.tdchain.jbcc.Connection;
import org.apache.commons.lang3.StringUtils;

public class ConnectionFactory {
    protected static String[] ipTables;
    protected static int port;
    protected static String token;
    protected static String keystorePath;
    protected static String keystorePasswd;
    protected static Cipher cipher;
    protected static long timeout;
    public static boolean soutSwitch;
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int DEFAULT_PORT = 18088;
    public static final int DEFAULT_MAX_TIMEOUT = 15000;
    protected static ConnectionConfig connectionConfig;
    public static final int MAX_TRANS_COUNT = 100;
    public static final int MAX_TRANS_HISTORY_COUNT = 29;

    public Connection getConnection() {
        return Singleton.INSTANCE.getConnection();
    }

    private static ConnectionFactory getFactory(ConnectionConfig connectionConfig) {
        if (connectionConfig == null) {
            throw new ConnectionException("connection config is null ");
        }
        ConnectionFactory.connectionConfig = connectionConfig;
        ConnectionFactory.validateConfig();
        return Singleton.INSTANCE.getFactory();
    }

    private ConnectionFactory(ConnectionConfig connectionConfig) {
        ConnectionFactory.connectionConfig = connectionConfig;
    }

    public static void validateConfig() {
        if (connectionConfig == null) {
            throw new ConnectionException("connection config is null ");
        }
        ipTables = connectionConfig.getIptables();
        if (ipTables == null || ipTables.length == 0 || ipTables[0] == null || ipTables[0].length() == 0) {
            throw new ConnectionException("iptables connfig error, please check iptables ");
        }
        port = connectionConfig.getPort();
        if (port < 1025 || port > 65534) {
            throw new ConnectionException("port error. [1025~65534] ");
        }
        token = connectionConfig.getToken();
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new ConnectionException("token is empty ");
        }
        keystorePath = connectionConfig.getKeystorePtah();
        if (StringUtils.isBlank((CharSequence)keystorePath)) {
            throw new ConnectionException("keystore path is empty ");
        }
        keystorePasswd = connectionConfig.getKeystorePassword();
        if (StringUtils.isBlank((CharSequence)keystorePasswd)) {
            throw new ConnectionException("keystore passwd is empty ");
        }
        cipher = new Cipher();
        if (Cipher.Type.SM == connectionConfig.getCipherType()) {
            cipher.setType(Cipher.Type.SM);
        }
        timeout = connectionConfig.getTimeout();
        soutSwitch = connectionConfig.getSoutSwitch();
    }

    static {
        soutSwitch = Boolean.FALSE;
    }

    static class ConnectionException
    extends RuntimeException {
        public ConnectionException() {
        }

        public ConnectionException(String msg) {
            super(msg);
        }
    }

    private static enum Singleton {
        INSTANCE;

        Connection singletonConnection;
        ConnectionFactory factory = new ConnectionFactory(connectionConfig);

        private Singleton() {
            this.singletonConnection = new Connection(ipTables, port, token, timeout, keystorePath, keystorePasswd, cipher);
        }

        public Connection getConnection() {
            return this.singletonConnection;
        }

        public ConnectionFactory getFactory() {
            return this.factory;
        }
    }

    public static class ConnectionConfig {
        private String[] iptables;
        private int port;
        private String token;
        private long timeout;
        private String keystorePtah;
        private String keystorePassword;
        private Cipher.Type cipherType = Cipher.Type.RSA;
        private boolean soutSwitch = false;

        public boolean getSoutSwitch() {
            return this.soutSwitch;
        }

        public String[] getIptables() {
            return this.iptables;
        }

        public int getPort() {
            return this.port;
        }

        public String getToken() {
            return this.token;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public String getKeystorePtah() {
            return this.keystorePtah;
        }

        public String getKeystorePassword() {
            return this.keystorePassword;
        }

        ConnectionConfig(String[] iptables, int port, String token, long timeout, String keystorePtah, String keystorePassword, Cipher.Type cipherType, boolean soutSwitch) {
            this.iptables = iptables;
            this.port = port;
            this.token = token;
            this.timeout = timeout;
            this.keystorePtah = keystorePtah;
            this.keystorePassword = keystorePassword;
            this.cipherType = cipherType;
            this.soutSwitch = soutSwitch;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Cipher.Type getCipherType() {
            return this.cipherType;
        }

        public static class Builder {
            private String[] iptables;
            private int port = 18088;
            private String token;
            private long timeout = 3000L;
            private String keystorePtah;
            private String keystorePassword;
            private Cipher.Type cipherType = Cipher.Type.RSA;
            private boolean soutSwitch;

            Builder() {
            }

            public Builder iptables(String[] iptables) {
                this.iptables = iptables;
                return this;
            }

            public Builder port(int port) {
                this.port = port;
                return this;
            }

            public Builder token(String token) {
                this.token = token;
                return this;
            }

            public Builder timeout(long timeout) {
                this.timeout = timeout <= 0L ? 15000L : timeout;
                return this;
            }

            public Builder keystorePath(String keystorePtah) {
                this.keystorePtah = keystorePtah;
                return this;
            }

            public Builder showPrint() {
                this.soutSwitch = true;
                return this;
            }

            public Builder keystorePassword(String keystorePassword) {
                this.keystorePassword = keystorePassword;
                return this;
            }

            public Builder cipherType(Cipher.Type cipherType) {
                this.cipherType = cipherType;
                return this;
            }

            public ConnectionFactory build() {
                ConnectionConfig connectionConfig = new ConnectionConfig(this.iptables, this.port, this.token, this.timeout, this.keystorePtah, this.keystorePassword, this.cipherType, this.soutSwitch);
                return ConnectionFactory.getFactory(connectionConfig);
            }
        }
    }
}

