/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc;

import cn.tdchain.Trans;
import cn.tdchain.cipher.rsa.Sha256Util;
import cn.tdchain.cipher.utils.HashCheckUtil;
import cn.tdchain.jbcc.BatchTrans;
import cn.tdchain.jbcc.TransInfoException;
import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TransUtil {
    public static final int HASH_LENGTH = 64;

    public static String getTransHash(Trans tx) {
        JSONObject txJsonO = (JSONObject)JSONObject.toJSON((Object)tx);
        txJsonO.remove((Object)"hash");
        txJsonO.remove((Object)"blockHash");
        txJsonO.remove((Object)"connectionId");
        txJsonO.remove((Object)"status");
        txJsonO.remove((Object)"msg");
        txJsonO.remove((Object)"index");
        txJsonO.remove((Object)"preHash");
        txJsonO.remove((Object)"author");
        txJsonO.remove((Object)"version");
        txJsonO.remove((Object)"height");
        txJsonO.remove((Object)"signMap");
        if (null == tx.getSignMap() && null == tx.getCategory() && null == tx.getKeyVersionMap()) {
            txJsonO.remove((Object)"signMap");
            txJsonO.remove((Object)"keyVersionMap");
            txJsonO.remove((Object)"category");
        }
        String txJsonStr = txJsonO.toJSONString();
        String hash = Sha256Util.hash(txJsonStr);
        return hash;
    }

    public static void verifyContratTrans(Trans trans) {
        if (trans == null) {
            throw new TransInfoException("trans is null");
        }
        if (StringUtils.isBlank((CharSequence)trans.getAccount())) {
            throw new TransInfoException("trans account should init");
        }
        if (StringUtils.isBlank((CharSequence)trans.getData())) {
            throw new TransInfoException("trans data is blank");
        }
        if (trans.getTimestamp() == null) {
            throw new TransInfoException("trans timestamp is null");
        }
    }

    public static Long getHeight(String hashHeight) {
        if (StringUtils.isBlank((CharSequence)hashHeight) || hashHeight.length() <= 64) {
            throw new RuntimeException("getHeight: split hash height exception, hash string: " + hashHeight);
        }
        Long height = 0L;
        try {
            height = Long.valueOf(hashHeight.substring(64));
        }
        catch (Exception e) {
            throw new RuntimeException("getHeight: split hash height exception, hash string: " + hashHeight);
        }
        return height;
    }

    public static Long getHeight(Trans trans) {
        if (trans == null) {
            throw new RuntimeException("trans is null");
        }
        String hashHeight = trans.getHash();
        return TransUtil.getHeight(hashHeight);
    }

    public static String getHash(String hashHeight) {
        if (StringUtils.isBlank((CharSequence)hashHeight) || hashHeight.length() <= 64) {
            throw new RuntimeException("split hash string exception, hash string: " + hashHeight);
        }
        String hash = "";
        try {
            hash = hashHeight.substring(0, 64);
        }
        catch (Exception e) {
            throw new RuntimeException("getHeight: split hash string exception, hash string: " + hashHeight);
        }
        return hash;
    }

    public static String getHash(Trans trans) {
        if (trans == null) {
            throw new RuntimeException("trans is null");
        }
        String hashHeight = trans.getHash();
        return TransUtil.getHash(hashHeight);
    }

    public static String hashHeight(String hash, Long height) {
        if (StringUtils.isBlank((CharSequence)hash) || !HashCheckUtil.hashCheck(hash)) {
            throw new TransInfoException("trans hash is error, hash=" + hash);
        }
        if (height == null || height < 0L) {
            throw new TransInfoException("block height is null or less zero");
        }
        return hash.concat(height + "");
    }

    public static void main(String[] args) {
        String str = "937d45babcf5fac3a3b889957cfd706c8ce1d1e5542acecfca8e1764a3e068b2";
        System.out.println(TransUtil.getHeight(str));
        System.out.println(TransUtil.getHash(str));
    }

    public static String getKeyAndAccountStr(String key, String account) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(account);
        return key + "&" + account;
    }

    public static Set<String> getBatchKeyAndAccountStrs(BatchTrans<? extends Trans> batchTrans) {
        if (batchTrans == null) {
            return new HashSet<String>();
        }
        if (CollectionUtils.isEmpty(batchTrans.getTransSet())) {
            return new HashSet<String>();
        }
        Set<String> result = batchTrans.getTransSet().stream().map(k -> TransUtil.getKeyAndAccountStr(k.getKey(), k.getAccount())).collect(Collectors.toSet());
        return result;
    }

    public static boolean verifyKey(String key) {
        if (StringUtils.isBlank((CharSequence)key) || key.length() > 64) {
            throw new TransInfoException("key is null or too long, max size is 64.");
        }
        if (key.matches(".*?\\s+?.*?")) {
            throw new TransInfoException("key:{" + key + "} has space character.");
        }
        if (key.matches("\\d+")) {
            throw new TransInfoException("key:{" + key + "} should not numbers only.");
        }
        if (HashCheckUtil.illegalCharacterCheck(key)) {
            throw new TransInfoException("key have Illegal character.");
        }
        return true;
    }
}

