/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc;

import cn.tdchain.jbcc.Result;
import cn.tdchain.jbcc.rpc.RPCResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RPCBatchResult {
    private String messageId;
    private boolean isTimeOut;
    private boolean isFail;
    private List<Result> list = new ArrayList<Result>();
    private Result result;
    private String msg;

    public static RPCBatchResult newInstance() {
        return new RPCBatchResult();
    }

    public RPCBatchResult add(Result result) {
        this.list.add(result);
        return this;
    }

    public RPCBatchResult result(Result result) {
        this.result = result;
        return this;
    }

    public RPCBatchResult messageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public RPCBatchResult msg(String msg) {
        this.msg = msg;
        return this;
    }

    public RPCBatchResult isTimeOut(boolean isTimeOut) {
        this.isTimeOut = isTimeOut;
        if (isTimeOut) {
            this.isFail = true;
        }
        return this;
    }

    public RPCBatchResult isFail(boolean isFail) {
        this.isFail = isFail;
        return this;
    }

    public boolean isFail() {
        return this.isFail;
    }

    public int size() {
        return this.list.size();
    }

    public Result getResult() {
        if (this.result != null) {
            return this.result;
        }
        this.result = new Result();
        this.result.setMsg(this.msg);
        if (this.isTimeOut) {
            this.result.setStatus(RPCResult.StatusType.timeout);
        }
        return this.result;
    }

    public <T> List<Result<T>> buildList(TypeReference<T> typeReference) {
        ArrayList<Result<T>> nresult = new ArrayList<Result<T>>();
        for (Result result : this.list) {
            if (result == null) continue;
            Object entity = result.getEntity();
            if (entity != null) {
                if (entity instanceof JSON) {
                    JSON json = (JSON)entity;
                    Object o = JSON.parseObject((String)json.toJSONString(), typeReference, (Feature[])new Feature[0]);
                    result.setEntity(o);
                } else {
                    Object o = JSON.parseObject((String)entity.toString(), typeReference, (Feature[])new Feature[0]);
                    result.setEntity(o);
                }
            }
            nresult.add(result);
        }
        return nresult;
    }

    public <T> Result<T> getResult(TypeReference<T> typeReference) {
        int failcount;
        if (this.isFail) {
            return this.getResult();
        }
        List<Result<T>> results = this.buildList(typeReference);
        Map<RPCResult.StatusType, List<Result>> fresult = results.stream().collect(Collectors.groupingBy(Result::getStatus));
        List<Result> success = fresult.get((Object)RPCResult.StatusType.succes);
        List<Result> fail = fresult.get((Object)RPCResult.StatusType.fail);
        int succescount = success == null ? 0 : success.size();
        int n = failcount = fail == null ? 0 : fail.size();
        if (succescount >= failcount) {
            return success.get(0);
        }
        return fail.get(0);
    }
}

