/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.nio.handler;

import cn.tdchain.cipher.rsa.AesUtil;
import cn.tdchain.jbcc.rpc.nio.handler.NioHandshakerType;
import cn.tdchain.jbcc.rpc.nio.handler.NioRpcClientException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.Promise;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class NioAuthChannelHandler
extends ChannelInboundHandlerAdapter {
    private Map<NioHandshakerType, String> handshakerMap = new HashMap<NioHandshakerType, String>();
    private Promise<Map<NioHandshakerType, String>> promise = null;
    private String token;
    private String publicKey;
    private String connectionId;

    public NioAuthChannelHandler(Promise<Map<NioHandshakerType, String>> promise, String token, String connectionId, String publicKey) {
        this.promise = promise;
        this.token = token;
        this.publicKey = publicKey;
        this.connectionId = connectionId;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        String authSequence = (String)msg;
        if (!this.handshakerMap.containsKey((Object)NioHandshakerType.HAND_2)) {
            String data = this.handshakerMap.get((Object)NioHandshakerType.AUTH);
            String decode = authSequence.split(";")[0];
            String encode = authSequence.split(";")[1];
            if (data.equals(decode) && (data = AesUtil.decrypt(encode, this.token)) != null) {
                this.handshakerMap.put(NioHandshakerType.HAND_2, NioHandshakerType.HAND_2.name());
                ctx.writeAndFlush((Object)data);
            }
            return;
        }
        if (!this.handshakerMap.containsKey((Object)NioHandshakerType.HAND_3)) {
            this.handshakerMap.put(NioHandshakerType.SERVER_PUBLIC_KEY, authSequence);
            this.handshakerMap.put(NioHandshakerType.HAND_3, NioHandshakerType.HAND_3.name());
            String keyAndConnectId = this.publicKey + ";" + this.connectionId;
            ChannelFuture future = ctx.writeAndFlush((Object)keyAndConnectId);
            future.addListener(f -> {
                if (f.isSuccess()) {
                    this.promise.trySuccess(this.handshakerMap);
                } else {
                    this.promise.tryFailure((Throwable)new NioRpcClientException("auth handshaker failed!"));
                }
            });
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        String uuid = UUID.randomUUID().toString();
        String encode = AesUtil.encrypt(uuid, this.token);
        this.handshakerMap.put(NioHandshakerType.AUTH, uuid);
        ctx.writeAndFlush((Object)encode);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.close();
        cause.printStackTrace();
    }
}

