/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.rpc.nio.handler;

import cn.tdchain.jbcc.net.nio.NioNet;
import cn.tdchain.jbcc.rpc.nio.client.NioRpcClient;
import cn.tdchain.jbcc.rpc.nio.handler.NioRpcClientPoolConfig;
import io.netty.channel.ChannelFactory;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class NioPoolableRpcClientFactory
extends BasePooledObjectFactory<NioRpcClient> {
    private ChannelFactory channelFactory;
    private String clientPublicKey = null;
    private String address = null;
    private String token = null;
    private int port;
    private long timeout = -1L;
    private String connectionId;
    private NioNet.NioTask task;

    public NioPoolableRpcClientFactory(NioRpcClientPoolConfig config, NioNet.NioTask task) {
        this.channelFactory = config.getChannelFactory();
        this.address = config.getAddress();
        this.port = config.getPort();
        this.timeout = config.getTimeout();
        this.token = config.getToken();
        this.connectionId = config.getConnectionId();
        this.clientPublicKey = config.getClientPublicKey();
        this.task = task;
    }

    public NioRpcClient create() {
        NioRpcClient client = new NioRpcClient(this.channelFactory, this.address, this.port, this.timeout, this.token, this.connectionId, this.clientPublicKey);
        return client;
    }

    public PooledObject<NioRpcClient> wrap(NioRpcClient client) {
        return new DefaultPooledObject((Object)client);
    }

    public void passivateObject(PooledObject<NioRpcClient> object) {
        NioRpcClient client;
        if (object != null && !(client = (NioRpcClient)object.getObject()).isActive()) {
            try {
                this.destroyObject(this.wrap(client));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void destroyObject(PooledObject<NioRpcClient> object) {
        if (object != null) {
            NioRpcClient client = (NioRpcClient)object;
            client.close();
        }
    }
}

