/*
 * Copyright (c) 2017 Beijing Tiande Technology Co., Ltd.
 * All Rights Reserved.
 */
package cn.tdchain.jbcc.rpc.nio.handler;

import cn.tdchain.jbcc.net.Net;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

/**
 * TCP message handler.
 *
 * @author murong 2018-08-03
 * @version 1.0
 */
public class NioHeartServerHandler extends ChannelInboundHandlerAdapter {

    private long nearTime = System.currentTimeMillis();

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        nearTime = System.currentTimeMillis();
        ctx.writeAndFlush(Net.heart);
    }

    public boolean isTimeOut() {
        long l = System.currentTimeMillis() - nearTime;
        if (l > 20000) {
            return true;
        }
        return false;
    }
}
