/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cipher;

import cn.tdchain.cipher.Cipher;

public class DataCipher {
    private String passwd;
    private String data;
    private String sign;

    public DataCipher() {
    }

    public DataCipher(String passwd, String data, String privateKey, String publicKey, Cipher cipher) {
        String sign;
        String hash = cipher.hash(data);
        this.sign = sign = cipher.signByPrivateKey(hash, privateKey);
        this.data = cipher.encrypt(data, passwd);
        this.passwd = cipher.encryptByPublicKey(passwd, publicKey);
    }

    public String getData(String privateKey, Cipher cipher) {
        String data;
        String p = cipher.decryptByPrivateKey(this.passwd, privateKey);
        if (p == null) {
            return null;
        }
        this.data = data = cipher.decrypt(this.data, p);
        return data;
    }

    public boolean verify(String senderPublicKey, Cipher cipher) {
        String hash = cipher.hash(this.data);
        return cipher.verifyByPublicKey(hash, this.sign, senderPublicKey);
    }

    public String getPasswd() {
        return this.passwd;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }
}

