/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cipher.cuda.client;

import cn.tdchain.jbcc.SoutUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;

public class TDRpcClient {
    private String address;
    private int port;
    private int timeOut = 3000;
    private Socket socket = null;

    public TDRpcClient(String address, int port, int timeOut) throws IOException {
        this.address = address;
        this.port = port;
        this.timeOut = timeOut;
        this.newSocket();
    }

    private synchronized void newSocket() throws IOException {
        if (this.socket != null) {
            this.close();
        }
        if (this.socket == null) {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(this.address, this.port), this.timeOut);
            this.socket.setTcpNoDelay(true);
        }
    }

    public void send(String msg) {
        try {
            if (this.socket == null || this.socket.isClosed() || !this.socket.isConnected()) {
                this.newSocket();
            }
            BufferedWriter oos = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            oos.write(msg);
            oos.newLine();
            oos.flush();
        }
        catch (Exception e) {
            this.close();
        }
    }

    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.socket = null;
        }
    }

    public String request(String msg) {
        String result = null;
        try {
            if (this.socket == null || this.socket.isClosed() || !this.socket.isConnected()) {
                this.newSocket();
            }
            BufferedWriter oos = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            oos.write(msg);
            oos.newLine();
            oos.flush();
            BufferedReader bfr = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            result = bfr.readLine();
        }
        catch (Exception e) {
            if (SoutUtil.isOpenSout()) {
                System.out.println(e.getMessage());
            }
            this.close();
        }
        return result;
    }
}

