/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cipher.cuda.client;

import cn.tdchain.cipher.cuda.client.TDRpcClient;
import cn.tdchain.jbcc.SoutUtil;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TDRpcClientPool {
    private int maxPoolSize = 16;
    private String addres;
    private int port;
    private int timeOut = 1000;
    private int minPoolSize = 1;
    private ConcurrentLinkedQueue<TDRpcClient> clientPool = new ConcurrentLinkedQueue();

    public TDRpcClientPool(String addres, int port) throws IOException {
        this(addres, port, 16, 1000);
    }

    public TDRpcClientPool(String addres, int port, int maxPoolSize) throws IOException {
        this(addres, port, maxPoolSize, 1000);
    }

    public TDRpcClientPool(String addres, int port, int maxPoolSize, int timeOut) throws IOException {
        this.addres = addres;
        this.port = port;
        this.maxPoolSize = maxPoolSize;
        this.timeOut = timeOut;
        int minPoolSize = maxPoolSize / 10;
        if (minPoolSize > 1) {
            this.minPoolSize = minPoolSize;
        }
        for (int i = 0; i < this.maxPoolSize; ++i) {
            this.newClient();
        }
    }

    private void newClient() throws IOException {
        if (this.clientPool.size() < this.maxPoolSize) {
            TDRpcClient client = new TDRpcClient(this.addres, this.port, this.timeOut);
            this.clientPool.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TDRpcClient getClient() {
        TDRpcClient c = null;
        try {
            long start = System.currentTimeMillis();
            while (true) {
                TDRpcClientPool tDRpcClientPool = this;
                synchronized (tDRpcClientPool) {
                    c = this.clientPool.poll();
                    if (c != null) {
                        return c;
                    }
                    if (System.currentTimeMillis() - start >= 1000L) {
                        return c;
                    }
                }
            }
        }
        catch (Exception e) {
            if (!SoutUtil.isOpenSout()) return c;
            System.out.println(e.getMessage());
        }
        return c;
    }

    public synchronized void returnClient(TDRpcClient client) {
        if (client == null) {
            return;
        }
        if (this.clientPool.size() < this.maxPoolSize) {
            this.clientPool.add(client);
        } else {
            client.close();
        }
    }

    public void drop() {
        while (this.clientPool.size() > 0) {
            TDRpcClient client = this.clientPool.poll();
            client.close();
        }
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public String getAddres() {
        return this.addres;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeOut() {
        return this.timeOut;
    }
}

