/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cipher.utils;

import cn.tdchain.cipher.CipherException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class FileUtils {
    private FileUtils() {
    }

    public static void saveFile(String path, Object value) {
        if (path == null || path.length() == 0) {
            return;
        }
        File ksPath = new File(path);
        ksPath.getParentFile().mkdirs();
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(path, true);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(value);
            oos.flush();
        }
        catch (Exception e) {
            throw new CipherException("save file to disk error:" + e.getMessage());
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readFile(String path) {
        String string = path;
        synchronized (string) {
            FileInputStream fis = null;
            ObjectInputStream ois = null;
            Object result = null;
            try {
                fis = new FileInputStream(path);
                ois = new ObjectInputStream(fis);
                result = ois.readObject();
            }
            catch (Exception e) {
                throw new CipherException("reader file error:" + e.getMessage());
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return result;
        }
    }
}

