/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.jbcc.net.io;

import cn.tdchain.cipher.Cipher;
import cn.tdchain.cipher.DataCipher;
import cn.tdchain.cipher.Key;
import cn.tdchain.jbcc.net.io.IONet;
import cn.tdchain.jbcc.rpc.RPCMessage;
import cn.tdchain.jbcc.rpc.exception.RpcException;
import cn.tdchain.jbcc.rpc.io.client.RpcClient;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;

public class Request {
    private IONet.Task task;
    private int workerNum = 1;
    private RequestPool pool;
    private String ip;
    private Cipher cipher;
    private String token;
    private Key key;
    private boolean status = true;
    private String connectionId;
    private String serverPublicKey = null;
    int error_num = 0;

    public Request(IONet.Task task, String serverHost, int serverPort, Cipher cipher, String token, Key key, String connectionId, int workerNum, String serverPublicKey) {
        this.task = task;
        this.connectionId = connectionId;
        this.key = key;
        this.token = token;
        this.cipher = cipher;
        this.ip = serverHost;
        if (workerNum > this.workerNum) {
            this.workerNum = workerNum;
        }
        this.serverPublicKey = serverPublicKey;
        this.pool = new RequestPool();
    }

    public void start() {
        this.pool.start();
        if (this.status) {
            final long wait_time = 50L;
            for (int i = 0; i < this.workerNum; ++i) {
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (Request.this.status) {
                            List<RPCMessage> msgList = Request.this.pool.getMsgList(1000);
                            if (msgList.size() > 0) {
                                RPCMessage batch_msg = new RPCMessage();
                                batch_msg.setTarget(Request.this.ip);
                                batch_msg.setTargetType(RPCMessage.TargetType.BATCH_REQUEST);
                                batch_msg.setSender(Request.this.connectionId);
                                batch_msg.setMsg(JSONObject.toJSONString(msgList));
                                DataCipher data = new DataCipher(UUID.randomUUID().toString(), batch_msg.getMsg(), Request.this.key.getPrivateKey(), Request.this.serverPublicKey, Request.this.cipher);
                                batch_msg.setMsg(JSON.toJSONString((Object)data));
                                RpcClient client = null;
                                try {
                                    client = Request.this.task.getClient();
                                    client.send(batch_msg.toJsonString());
                                    Request.this.error_num = 0;
                                }
                                catch (SocketTimeoutException e) {
                                    e.printStackTrace();
                                }
                                catch (ConnectException e) {
                                    Request.this.error_num = this.close(Request.this.error_num, client, e);
                                }
                                catch (IOException e) {
                                    Request.this.error_num = this.close(Request.this.error_num, client, e);
                                }
                                catch (RpcException e) {
                                    Request.this.error_num = this.close(Request.this.error_num, client, e);
                                }
                                catch (Exception e) {
                                    Request.this.error_num = this.close(Request.this.error_num, client, e);
                                }
                                finally {
                                    Request.this.task.returnClient(client);
                                }
                                if (Request.this.error_num > 5) {
                                    Request.this.task.stop();
                                }
                            }
                            try {
                                Thread.sleep(wait_time);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }

                    private int close(int error_num, RpcClient client, Exception e) {
                        ++error_num;
                        if (client != null) {
                            client.close(e);
                        }
                        return error_num;
                    }
                }).start();
                try {
                    Thread.sleep(wait_time / (long)this.workerNum);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void addRequest(RPCMessage msg) {
        if (this.status) {
            this.pool.add(msg);
        }
    }

    public void stop() {
        this.status = false;
        this.pool.stop();
    }

    public class RequestPool {
        private boolean status = true;
        private LinkedBlockingQueue<RPCMessage> queue = new LinkedBlockingQueue();

        public void add(RPCMessage msg) {
            if (this.status) {
                this.queue.add(msg);
            }
        }

        public List<RPCMessage> getMsgList(int maxSize) {
            ArrayList<RPCMessage> msgList = new ArrayList<RPCMessage>();
            for (int i = 0; i < maxSize; ++i) {
                RPCMessage msg = this.queue.poll();
                if (msg == null) continue;
                msgList.add(msg);
            }
            return msgList;
        }

        public void start() {
            this.status = true;
        }

        public void stop() {
            this.status = false;
        }
    }
}

